/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.network;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.network.BasePacket;
import aztech.modern_industrialization.network.armor.ActivateItemPacket;
import aztech.modern_industrialization.network.armor.UpdateKeysPacket;
import aztech.modern_industrialization.network.machines.AdjustSlotCapacityPacket;
import aztech.modern_industrialization.network.machines.ChangeShapePacket;
import aztech.modern_industrialization.network.machines.DoSlotDraggingPacket;
import aztech.modern_industrialization.network.machines.ForgeHammerMoveRecipePacket;
import aztech.modern_industrialization.network.machines.LockAllPacket;
import aztech.modern_industrialization.network.machines.MachineComponentSyncPacket;
import aztech.modern_industrialization.network.machines.ReiLockSlotsPacket;
import aztech.modern_industrialization.network.machines.SetAutoExtractPacket;
import aztech.modern_industrialization.network.machines.SetLockingModePacket;
import aztech.modern_industrialization.network.machines.UpdateFluidSlotPacket;
import aztech.modern_industrialization.network.machines.UpdateItemSlotPacket;
import aztech.modern_industrialization.network.pipes.IncrementPriorityPacket;
import aztech.modern_industrialization.network.pipes.SetConnectionTypePacket;
import aztech.modern_industrialization.network.pipes.SetItemWhitelistPacket;
import aztech.modern_industrialization.network.pipes.SetNetworkFluidPacket;
import aztech.modern_industrialization.network.pipes.SetPriorityPacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class MIPackets {
    static final Map<Class<? extends BasePacket>, CustomPacketPayload.Type<?>> packetTypes = new HashMap();
    private static final List<Registration<?>> registrations = new ArrayList();

    private static <P extends BasePacket> void register(String path, Class<P> clazz, StreamCodec<? super RegistryFriendlyByteBuf, P> packetConstructor) {
        CustomPacketPayload.Type type = new CustomPacketPayload.Type(MI.id(path));
        packetTypes.put(clazz, type);
        registrations.add(new Registration<P>(type, clazz, packetConstructor));
    }

    public static void init(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        for (Registration<?> reg : registrations) {
            MIPackets.register(registrar, reg);
        }
    }

    private static <P extends BasePacket> void register(PayloadRegistrar registrar, Registration<P> reg) {
        registrar.playBidirectional(reg.packetType, reg.packetCodec, (packet, context) -> packet.handle(new BasePacket.Context(reg.clazz, context)));
    }

    static {
        MIPackets.register("activate_chest", ActivateItemPacket.class, ActivateItemPacket.STREAM_CODEC);
        MIPackets.register("update_keys", UpdateKeysPacket.class, UpdateKeysPacket.STREAM_CODEC);
        MIPackets.register("adjust_slot_capacity", AdjustSlotCapacityPacket.class, AdjustSlotCapacityPacket.STREAM_CODEC);
        MIPackets.register("do_slot_dragging", DoSlotDraggingPacket.class, DoSlotDraggingPacket.STREAM_CODEC);
        MIPackets.register("lock_all", LockAllPacket.class, LockAllPacket.STREAM_CODEC);
        MIPackets.register("machine_component_sync", MachineComponentSyncPacket.class, MachineComponentSyncPacket.STREAM_CODEC);
        MIPackets.register("set_locking_mode", SetLockingModePacket.class, SetLockingModePacket.STREAM_CODEC);
        MIPackets.register("update_fluid_slot", UpdateFluidSlotPacket.class, UpdateFluidSlotPacket.STREAM_CODEC);
        MIPackets.register("update_item_slot", UpdateItemSlotPacket.class, UpdateItemSlotPacket.STREAM_CODEC);
        MIPackets.register("change_shape", ChangeShapePacket.class, ChangeShapePacket.STREAM_CODEC);
        MIPackets.register("forge_hammer_move_recipe", ForgeHammerMoveRecipePacket.class, ForgeHammerMoveRecipePacket.STREAM_CODEC);
        MIPackets.register("rei_lock_slots", ReiLockSlotsPacket.class, ReiLockSlotsPacket.STREAM_CODEC);
        MIPackets.register("set_auto_extract", SetAutoExtractPacket.class, SetAutoExtractPacket.STREAM_CODEC);
        MIPackets.register("increment_priority", IncrementPriorityPacket.class, IncrementPriorityPacket.STREAM_CODEC);
        MIPackets.register("set_connection_type", SetConnectionTypePacket.class, SetConnectionTypePacket.STREAM_CODEC);
        MIPackets.register("set_item_whitelist", SetItemWhitelistPacket.class, SetItemWhitelistPacket.STREAM_CODEC);
        MIPackets.register("set_network_fluid", SetNetworkFluidPacket.class, SetNetworkFluidPacket.STREAM_CODEC);
        MIPackets.register("set_priority", SetPriorityPacket.class, SetPriorityPacket.STREAM_CODEC);
    }

    private record Registration<P extends BasePacket>(CustomPacketPayload.Type<P> packetType, Class<P> clazz, StreamCodec<? super RegistryFriendlyByteBuf, P> packetCodec) {
    }
}

