/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes.api;

import aztech.modern_industrialization.pipes.MIPipes;
import aztech.modern_industrialization.pipes.api.PipeNetwork;
import aztech.modern_industrialization.pipes.api.PipeNetworkData;
import aztech.modern_industrialization.pipes.api.PipeNetworkNode;
import aztech.modern_industrialization.pipes.api.PipeNetworkType;
import aztech.modern_industrialization.util.NbtHelper;
import aztech.modern_industrialization.util.WorldHelper;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.neoforged.fml.loading.FMLEnvironment;
import org.jspecify.annotations.Nullable;

public class PipeNetworkManager {
    private static final boolean DEBUG_CHECKS = !FMLEnvironment.production;
    private final Map<BlockPos, PipeNetwork> networkByBlock = new HashMap<BlockPos, PipeNetwork>();
    private final Map<BlockPos, Set<Direction>> links = new HashMap<BlockPos, Set<Direction>>();
    private final Set<PipeNetwork> networks = new HashSet<PipeNetwork>();
    private int nextNetworkId = 0;
    private final PipeNetworkType type;
    private final Map<Long, Set<BlockPos>> spannedChunks = new HashMap<Long, Set<BlockPos>>();
    protected LongSet tickingChunks = new LongOpenHashSet();
    protected LongSet lastTickingChunks = new LongOpenHashSet();

    public PipeNetworkManager(PipeNetworkType type) {
        this.type = type;
    }

    public void tickNetworks(ServerLevel world) {
        this.updateTickingChunks(world);
        for (PipeNetwork network : this.networks) {
            network.tick(world);
        }
        LongIterator longIterator = this.tickingChunks.iterator();
        while (longIterator.hasNext()) {
            int chunkZ;
            long chunkPos = (Long)longIterator.next();
            int chunkX = ChunkPos.getX((long)chunkPos);
            ChunkAccess chunk = world.getChunk(chunkX, chunkZ = ChunkPos.getZ((long)chunkPos), ChunkStatus.FULL, false);
            if (chunk != null) {
                chunk.setUnsaved(true);
                continue;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("MI pipes issue: ticking spanned chunk was not loaded anymore. Please report this.\n");
            sb.append(" - Pipe type: ").append(this.type.getIdentifier()).append("\n");
            sb.append(" - Chunk: %d,%d\n".formatted(chunkX, chunkZ));
            sb.append(" - Blocks in chunk:\n");
            Iterator it = this.spannedChunks.get(chunkPos).stream().sorted().iterator();
            while (it.hasNext()) {
                BlockPos pos = (BlockPos)it.next();
                sb.append("   - Pos: %d %d %d\n".formatted(pos.getX(), pos.getY(), pos.getZ()));
                PipeNetwork network = this.networkByBlock.get(pos);
                String node = network == null ? "none" : (network.getNode(pos) == null ? "not loaded" : "loaded");
                sb.append("   - Has network (should be true): %s\n".formatted(network != null));
                sb.append("   - Node status (should be loaded): %s\n".formatted(node));
            }
            throw new UnsupportedOperationException(sb.toString());
        }
    }

    public boolean hasNode(BlockPos pos) {
        return this.networkByBlock.containsKey(pos);
    }

    private void updateTickingChunks(ServerLevel world) {
        LongSet tmp = this.tickingChunks;
        this.tickingChunks = this.lastTickingChunks;
        this.lastTickingChunks = tmp;
        Preconditions.checkState((boolean)this.tickingChunks.isEmpty(), (Object)"Internal pipe network error.");
        for (Map.Entry<Long, Set<BlockPos>> entry : this.spannedChunks.entrySet()) {
            long chunk = entry.getKey();
            if (!WorldHelper.isChunkTicking(world, chunk)) continue;
            this.tickingChunks.add(chunk);
            if (this.lastTickingChunks.remove(chunk)) continue;
            this.notifyTickingChanged(entry.getValue());
        }
        for (Long notTickingChunk : this.lastTickingChunks) {
            this.notifyTickingChanged(this.spannedChunks.get(notTickingChunk));
        }
        this.lastTickingChunks.clear();
    }

    private void notifyTickingChanged(@Nullable Set<BlockPos> positionsInChunk) {
        if (positionsInChunk != null) {
            for (BlockPos pos : positionsInChunk) {
                PipeNetwork network = this.networkByBlock.get(pos);
                network.tickingCacheValid = false;
            }
        }
    }

    public void addLink(BlockPos pos, Direction direction, boolean force) {
        if (this.hasLink(pos, direction)) {
            return;
        }
        if (!this.canLink(pos, direction, force)) {
            return;
        }
        BlockPos otherPos = pos.relative(direction);
        this.links.get(pos).add(direction);
        this.links.get(otherPos).add(direction.getOpposite());
        PipeNetwork network = this.networkByBlock.get(pos);
        PipeNetwork otherNetwork = this.networkByBlock.get(otherPos);
        if (network != otherNetwork) {
            if (!network.data.equals(otherNetwork.data)) {
                network.data = network.merge(otherNetwork);
            }
            for (Map.Entry<BlockPos, PipeNetworkNode> entry : otherNetwork.getRawNodeMap().entrySet()) {
                PipeNetworkNode node = entry.getValue();
                BlockPos nodePos = entry.getKey();
                if (node != null) {
                    node.network = network;
                }
                this.networkByBlock.put(nodePos, network);
                network.setNode(nodePos, node);
            }
            ArrayList<BlockPos> nodesCopy = new ArrayList<BlockPos>(otherNetwork.getRawNodeMap().keySet());
            for (BlockPos nodePos : nodesCopy) {
                otherNetwork.removeNode(nodePos);
            }
            otherNetwork.onRemove();
            this.networks.remove(otherNetwork);
        }
        network.tickingCacheValid = false;
        this.checkStateCoherence();
    }

    public void removeLink(BlockPos pos, Direction direction) {
        if (!this.hasLink(pos, direction)) {
            return;
        }
        BlockPos otherPos = pos.relative(direction);
        this.links.get(pos).remove(direction);
        this.links.get(otherPos).remove(direction.getOpposite());
        PipeNetwork network = this.networkByBlock.get(pos);
        final HashMap<BlockPos, PipeNetworkNode> unvisitedNodes = new HashMap<BlockPos, PipeNetworkNode>(network.getRawNodeMap());
        network.tickingCacheValid = false;
        class Dfs {
            Dfs() {
            }

            private void dfs(BlockPos currentPos) {
                if (!unvisitedNodes.containsKey(currentPos)) {
                    return;
                }
                unvisitedNodes.remove(currentPos);
                for (Direction direction : PipeNetworkManager.this.links.get(currentPos)) {
                    this.dfs(currentPos.relative(direction));
                }
            }
        }
        Dfs dfs = new Dfs();
        dfs.dfs(pos);
        if (unvisitedNodes.size() > 0) {
            PipeNetwork newNetwork = this.createNetwork(network.data.clone());
            for (Map.Entry entry : unvisitedNodes.entrySet()) {
                PipeNetworkNode node = (PipeNetworkNode)entry.getValue();
                BlockPos nodePos = (BlockPos)entry.getKey();
                if (node != null) {
                    node.network = newNetwork;
                }
                this.networkByBlock.put(nodePos, newNetwork);
                newNetwork.setNode(nodePos, node);
                network.removeNode(nodePos);
            }
        }
        this.checkStateCoherence();
    }

    public boolean hasLink(BlockPos pos, Direction direction) {
        Set<Direction> nodeLinks = this.links.get(pos);
        return nodeLinks != null && nodeLinks.contains(direction);
    }

    public boolean canLink(BlockPos pos, Direction direction, boolean forceLink) {
        BlockPos otherPos = pos.relative(direction);
        PipeNetwork network = this.networkByBlock.get(pos);
        PipeNetwork otherNetwork = this.networkByBlock.get(otherPos);
        return otherNetwork != null && (network.data.equals(otherNetwork.data) || forceLink && network.merge(otherNetwork) != null);
    }

    public void addNode(PipeNetworkNode node, BlockPos pos, PipeNetworkData data) {
        if (this.networkByBlock.containsKey(pos)) {
            throw new IllegalArgumentException("Cannot add a node that is already in the network.");
        }
        PipeNetwork network = this.createNetwork(data.clone());
        if (node != null) {
            node.network = network;
        }
        this.networkByBlock.put(pos.immutable(), network);
        this.incrementSpanned(pos);
        network.setNode(pos, node);
        this.links.put(pos.immutable(), new HashSet());
        this.checkStateCoherence();
    }

    public void removeNode(BlockPos pos) {
        for (Direction direction : Direction.values()) {
            this.removeLink(pos, direction);
        }
        PipeNetwork network = this.networkByBlock.remove(pos);
        this.decrementSpanned(pos);
        network.onRemove();
        this.networks.remove(network);
        this.links.remove(pos);
        this.checkStateCoherence();
    }

    public void nodeLoaded(PipeNetworkNode node, BlockPos pos) {
        PipeNetwork network = this.networkByBlock.get(pos);
        if (network == null) {
            PipeNetworkData data = MIPipes.INSTANCE.getPipeItem((PipeNetworkType)this.getType()).defaultData.clone();
            this.addNode(node, pos, data);
            for (Direction direction : Direction.values()) {
                this.addLink(pos, direction, false);
            }
        } else {
            node.network = network;
            network.setNode(pos, node);
            network.tickingCacheValid = false;
        }
        this.incrementSpanned(pos);
        this.checkStateCoherence();
    }

    public void nodeUnloaded(PipeNetworkNode node, BlockPos pos) {
        node.network.setNode(pos, null);
        node.network.tickingCacheValid = false;
        this.decrementSpanned(pos);
        this.checkStateCoherence();
    }

    private PipeNetwork createNetwork(PipeNetworkData data) {
        PipeNetwork network = this.type.getNetworkCtor().apply(this.nextNetworkId, data);
        network.manager = this;
        ++this.nextNetworkId;
        this.networks.add(network);
        this.checkStateCoherence();
        return network;
    }

    private void incrementSpanned(BlockPos pos) {
        this.spannedChunks.computeIfAbsent(ChunkPos.asLong((BlockPos)pos), p -> new HashSet()).add(pos.immutable());
    }

    private void decrementSpanned(BlockPos pos) {
        long chunkPos = ChunkPos.asLong((BlockPos)pos);
        Set<BlockPos> set = this.spannedChunks.get(chunkPos);
        set.remove(pos);
        if (set.size() == 0) {
            this.spannedChunks.remove(chunkPos);
        }
    }

    public void fromNbt(CompoundTag tag, HolderLookup.Provider registries) {
        ListTag networksTag = tag.getList("networks", (int)new CompoundTag().getId());
        for (Object networkTag : networksTag) {
            PipeNetwork network = this.type.getNetworkCtor().apply(-1, null);
            network.manager = this;
            network.fromTag((CompoundTag)networkTag, registries);
            this.networks.add(network);
        }
        HashMap<Integer, PipeNetwork> networkIds = new HashMap<Integer, PipeNetwork>();
        for (PipeNetwork network : this.networks) {
            networkIds.put(network.id, network);
        }
        int[] data = tag.getIntArray("networkByBlock");
        for (int i = 0; i < data.length / 5; ++i) {
            PipeNetwork network = (PipeNetwork)networkIds.get(data[5 * i + 3]);
            BlockPos pos = new BlockPos(data[5 * i], data[5 * i + 1], data[5 * i + 2]);
            this.networkByBlock.put(pos, network);
            network.setNode(pos, null);
            this.links.put(pos, new HashSet<Direction>(Arrays.asList(NbtHelper.decodeDirections((byte)data[5 * i + 4]))));
        }
        this.nextNetworkId = tag.getInt("nextNetworkId");
        this.checkStateCoherence();
    }

    public CompoundTag toTag(CompoundTag tag, HolderLookup.Provider registries) {
        ArrayList<CompoundTag> networksTags = new ArrayList<CompoundTag>();
        for (PipeNetwork network : this.networks) {
            networksTags.add(network.toTag(new CompoundTag(), registries));
        }
        ListTag networksTag = new ListTag();
        networksTag.addAll(networksTags);
        tag.put("networks", (Tag)networksTag);
        int[] networkByBlockData = new int[this.networkByBlock.size() * 5];
        int i = 0;
        for (Map.Entry<BlockPos, PipeNetwork> entry : this.networkByBlock.entrySet()) {
            networkByBlockData[i++] = entry.getKey().getX();
            networkByBlockData[i++] = entry.getKey().getY();
            networkByBlockData[i++] = entry.getKey().getZ();
            networkByBlockData[i++] = entry.getValue().id;
            networkByBlockData[i++] = NbtHelper.encodeDirections((Iterable<Direction>)this.links.get(entry.getKey()));
        }
        tag.putIntArray("networkByBlock", networkByBlockData);
        tag.putInt("nextNetworkId", this.nextNetworkId);
        this.checkStateCoherence();
        return tag;
    }

    public PipeNetworkType getType() {
        return this.type;
    }

    public Set<Direction> getNodeLinks(BlockPos pos) {
        return new HashSet<Direction>((Collection)this.links.get(pos));
    }

    public void checkStateCoherence() {
        if (!DEBUG_CHECKS) {
            return;
        }
        this.customAssert(this.networkByBlock.keySet().equals(this.links.keySet()));
        for (Map.Entry<BlockPos, PipeNetwork> entry : this.networkByBlock.entrySet()) {
            this.customAssert(this.networks.contains(entry.getValue()));
            PipeNetworkNode node = entry.getValue().getNode(entry.getKey());
            this.customAssert(node == null || node.network == entry.getValue());
        }
        for (Map.Entry<BlockPos, Object> entry : this.links.entrySet()) {
            this.customAssert(entry.getValue() != null);
        }
        for (PipeNetwork pipeNetwork : this.networks) {
            for (Map.Entry<BlockPos, PipeNetworkNode> entry : pipeNetwork.getRawNodeMap().entrySet()) {
                this.customAssert(entry.getValue() == null || entry.getValue().network == pipeNetwork);
                this.customAssert(this.networkByBlock.get(entry.getKey()) == pipeNetwork);
            }
        }
    }

    private void customAssert(boolean predicate) {
        if (!predicate) {
            throw new NullPointerException("Predicate was false");
        }
    }
}

