/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.resource;

import com.mojang.logging.LogUtils;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import net.minecraft.FileUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jspecify.annotations.Nullable;

public class FastPathPackResources
extends PathPackResources {
    private final Path root;
    private static final FileSystem DEFAULT_FS = FileSystems.getDefault();

    public FastPathPackResources(PackLocationInfo locationInfo, Path root) {
        super(locationInfo, root);
        this.root = root;
    }

    public @Nullable IoSupplier<InputStream> getResource(PackType packType, ResourceLocation location) {
        Path path = this.root.resolve(packType.getDirectory()).resolve(location.getNamespace());
        return FastPathPackResources.getResource(location, path);
    }

    public static IoSupplier<InputStream> getResource(ResourceLocation location, Path path) {
        return (IoSupplier)FileUtil.decomposePath((String)location.getPath()).mapOrElse(list -> {
            Path path2 = FileUtil.resolvePath((Path)path, (List)list);
            return FastPathPackResources.returnFileIfExists(path2);
        }, error -> {
            LogUtils.getLogger().error("Invalid path {}: {}", (Object)path, (Object)error.message());
            return null;
        });
    }

    private static @Nullable IoSupplier<InputStream> returnFileIfExists(Path path) {
        return FastPathPackResources.exists(path) && FastPathPackResources.validatePath((Path)path) ? IoSupplier.create((Path)path) : null;
    }

    private static boolean exists(Path path) {
        return path.getFileSystem() == DEFAULT_FS ? path.toFile().exists() : Files.exists(path, new LinkOption[0]);
    }
}

