/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.chipped.client.screens;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.architectury.injectables.annotations.ExpectPlatform;
import earth.terrarium.chipped.client.screens.neoforge.FakeLevelImpl;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class FakeLevel
implements BlockAndTintGetter {
    @Nullable
    private BlockState state;
    @Nullable
    private Set<BlockPos> positions;
    public static final Vector3f SCENE_LIGHT_1 = new Vector3f(1.0f, 0.0f, 1.0f);
    public static final Vector3f SCENE_LIGHT_2 = new Vector3f(-1.0f, 1.0f, -1.0f);

    public float getShade(Direction direction, boolean shade) {
        return 1.0f;
    }

    public LevelLightEngine getLightEngine() {
        throw new UnsupportedOperationException();
    }

    public int getBlockTint(BlockPos blockPos, ColorResolver colorResolver) {
        return Objects.requireNonNull(Minecraft.getInstance().level).getBlockTint(blockPos, colorResolver);
    }

    public int getBrightness(LightLayer lightType, BlockPos blockPos) {
        return 15;
    }

    public int getRawBrightness(BlockPos blockPos, int amount) {
        return 15;
    }

    @Nullable
    public BlockEntity getBlockEntity(BlockPos pos) {
        return null;
    }

    public BlockState getBlockState(BlockPos pos) {
        return this.state != null && this.positions != null && this.positions.contains(pos) ? this.state : Blocks.AIR.defaultBlockState();
    }

    public FluidState getFluidState(BlockPos pos) {
        return Blocks.AIR.defaultBlockState().getFluidState();
    }

    public int getHeight() {
        return 0;
    }

    public int getMinBuildHeight() {
        return 0;
    }

    public void setState(BlockState state) {
        this.state = state;
    }

    public void setPositions(Set<BlockPos> positions) {
        this.positions = positions;
    }

    public void renderBlock(PoseStack poseStack) {
        if (this.state == null || this.positions == null) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        BlockRenderDispatcher dispatcher = mc.getBlockRenderer();
        MultiBufferSource.BufferSource bufferSource = mc.renderBuffers().bufferSource();
        RenderType renderType = ItemBlockRenderTypes.getRenderType((BlockState)this.state, (boolean)false);
        VertexConsumer consumer = bufferSource.getBuffer(renderType);
        RenderSystem.setupGui3DDiffuseLighting((Vector3f)SCENE_LIGHT_1, (Vector3f)SCENE_LIGHT_2);
        this.positions.forEach(pos -> {
            poseStack.pushPose();
            poseStack.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
            FakeLevel.renderBatched(dispatcher, this.state, pos, this, poseStack, consumer, true, Objects.requireNonNull(mc.level).random, renderType);
            poseStack.popPose();
        });
        bufferSource.endBatch();
        Lighting.setupFor3DItems();
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void renderBatched(BlockRenderDispatcher dispatcher, BlockState state, BlockPos pos, BlockAndTintGetter level, PoseStack poseStack, VertexConsumer consumer, boolean checkSides, RandomSource random, RenderType type) {
        void var8_8;
        void var7_7;
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        FakeLevelImpl.renderBatched(dispatcher, (BlockState)var1_1, (BlockPos)var2_2, (BlockAndTintGetter)var3_3, (PoseStack)var4_4, (VertexConsumer)var5_5, (boolean)var6_6, (RandomSource)var7_7, (RenderType)var8_8);
    }
}

