/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.jei.common;

import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.grid.view.GridResource;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.grid.screen.AbstractGridScreen;
import com.refinedmods.refinedstorage.jei.common.ClickableIngredient;
import java.util.Optional;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.runtime.IClickableIngredient;
import mezz.jei.api.runtime.IIngredientManager;

class GridGuiContainerHandler
implements IGuiContainerHandler<AbstractGridScreen<?>> {
    private final IIngredientManager ingredientManager;

    GridGuiContainerHandler(IIngredientManager ingredientManager) {
        this.ingredientManager = ingredientManager;
    }

    public Optional<IClickableIngredient<?>> getClickableIngredientUnderMouse(AbstractGridScreen screen, double mouseX, double mouseY) {
        GridResource resource = screen.getCurrentGridResource();
        if (resource == null) {
            return Optional.empty();
        }
        PlatformResourceKey underlyingResource = resource.getResourceForRecipeMods();
        if (underlyingResource == null) {
            return Optional.empty();
        }
        return RefinedStorageApi.INSTANCE.getIngredientConverter().convertToIngredient(underlyingResource).flatMap(ingredient -> this.convertToClickableIngredient(mouseX, mouseY, ingredient));
    }

    private Optional<IClickableIngredient<?>> convertToClickableIngredient(double x, double y, Object ingredient) {
        IIngredientHelper helper = this.ingredientManager.getIngredientHelper(ingredient);
        Optional maybeTypedIngredient = this.ingredientManager.createTypedIngredient(helper.getIngredientType(), ingredient);
        return maybeTypedIngredient.map(typedIngredient -> new ClickableIngredient(typedIngredient, (int)x, (int)y));
    }
}

