/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mrcrayfish.furniture.refurbished.blockentity.fluid.FluidContainer;
import com.mrcrayfish.furniture.refurbished.platform.ClientServices;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import org.joml.Matrix4f;

public class SimpleFluidRenderer {
    public static void drawContainer(Level level, BlockPos pos, FluidContainer container, AABB box, PoseStack poseStack, MultiBufferSource source, int light) {
        if (!container.isEmpty()) {
            Fluid fluid = container.getStoredFluid();
            TextureAtlasSprite[] sprites = ClientServices.PLATFORM.getFluidSprites(fluid, (BlockAndTintGetter)level, pos, fluid.defaultFluidState());
            TextureAtlasSprite still = sprites[0];
            int colour = fluid.isSame((Fluid)Fluids.WATER) ? BiomeColors.getAverageWaterColor((BlockAndTintGetter)level, (BlockPos)pos) : 0xFFFFFF;
            float red = (float)FastColor.ARGB32.red((int)colour) / 255.0f;
            float green = (float)FastColor.ARGB32.green((int)colour) / 255.0f;
            float blue = (float)FastColor.ARGB32.blue((int)colour) / 255.0f;
            float fullness = (float)container.getStoredAmount() / (float)container.getCapacity();
            float offset = (float)(box.minY + (box.maxY - box.minY) * (double)fullness);
            float uScale = still.getU1() - still.getU0();
            float vScale = still.getV1() - still.getV0();
            float u0 = still.getU0() + uScale * (float)box.minX;
            float u1 = still.getU0() + uScale * (float)box.maxX;
            float v0 = still.getV0() + vScale * (float)box.minZ;
            float v1 = still.getV0() + vScale * (float)box.maxZ;
            RenderType type = RenderType.translucentMovingBlock();
            VertexConsumer consumer = source.getBuffer(type);
            Matrix4f matrix = poseStack.last().pose();
            consumer.addVertex(matrix, (float)box.minX, offset, (float)box.minZ).setColor(red, green, blue, 1.0f).setUv(u0, v0).setLight(light).setNormal(0.0f, 1.0f, 0.0f);
            consumer.addVertex(matrix, (float)box.minX, offset, (float)box.maxZ).setColor(red, green, blue, 1.0f).setUv(u0, v1).setLight(light).setNormal(0.0f, 1.0f, 0.0f);
            consumer.addVertex(matrix, (float)box.maxX, offset, (float)box.maxZ).setColor(red, green, blue, 1.0f).setUv(u1, v1).setLight(light).setNormal(0.0f, 1.0f, 0.0f);
            consumer.addVertex(matrix, (float)box.maxX, offset, (float)box.minZ).setColor(red, green, blue, 1.0f).setUv(u1, v0).setLight(light).setNormal(0.0f, 1.0f, 0.0f);
        }
    }

    public static AABB createRotatedBox(Direction direction, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        minX /= 16.0;
        minY /= 16.0;
        minZ /= 16.0;
        maxX /= 16.0;
        maxY /= 16.0;
        maxZ /= 16.0;
        return switch (direction) {
            case Direction.WEST -> new AABB(1.0 - maxX, minY, 1.0 - maxZ, 1.0 - minX, maxY, 1.0 - minZ);
            case Direction.NORTH -> new AABB(minZ, minY, 1.0 - maxX, maxZ, maxY, 1.0 - minX);
            case Direction.SOUTH -> new AABB(1.0 - maxZ, minY, minX, 1.0 - minZ, maxY, maxX);
            default -> new AABB(minX, minY, minZ, maxX, maxY, maxZ);
        };
    }
}

