/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.integration.crafttweaker.handlers;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.item.MCItemStack;
import com.blamejared.crafttweaker.api.item.MCItemStackMutable;
import com.blamejared.crafttweaker.api.recipe.component.BuiltinRecipeComponents;
import com.blamejared.crafttweaker.api.recipe.component.IDecomposedRecipe;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.StringUtil;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import vectorwing.farmersdelight.common.crafting.CuttingBoardRecipe;
import vectorwing.farmersdelight.common.crafting.ingredient.ChanceResult;
import vectorwing.farmersdelight.integration.crafttweaker.handlers.RecipeHandlerUtils;

@IRecipeHandler.For(value=CuttingBoardRecipe.class)
public class CuttingBoardRecipeHandler
implements IRecipeHandler<CuttingBoardRecipe> {
    public String dumpToCommandString(IRecipeManager<? super CuttingBoardRecipe> manager, RegistryAccess registryAccess, RecipeHolder<CuttingBoardRecipe> recipe) {
        Object[] objectArray = new Object[6];
        objectArray[0] = manager.getCommandString();
        objectArray[1] = StringUtil.quoteAndEscape((ResourceLocation)recipe.id());
        objectArray[2] = IIngredient.fromIngredient((Ingredient)((Ingredient)((CuttingBoardRecipe)recipe.value()).getIngredients().get(0))).getCommandString();
        objectArray[3] = ((CuttingBoardRecipe)recipe.value()).getResults().stream().map(MCItemStackMutable::new).map(IItemStack::getCommandString).collect(Collectors.joining(", ", "[", "]"));
        objectArray[4] = IIngredient.fromIngredient((Ingredient)((CuttingBoardRecipe)recipe.value()).getTool()).getCommandString();
        objectArray[5] = ((CuttingBoardRecipe)recipe.value()).getSoundEvent().map(arg_0 -> ((Registry)BuiltInRegistries.SOUND_EVENT).getKey(arg_0));
        return String.format("%s.addRecipe(%s, %s, %s, %s, %s);", objectArray);
    }

    public <U extends Recipe<?>> boolean doesConflict(IRecipeManager<? super CuttingBoardRecipe> manager, CuttingBoardRecipe firstRecipe, U secondRecipe) {
        return firstRecipe.equals(secondRecipe);
    }

    public Optional<IDecomposedRecipe> decompose(IRecipeManager<? super CuttingBoardRecipe> manager, RegistryAccess registryAccess, CuttingBoardRecipe recipe) {
        IDecomposedRecipe decomposedRecipe = IDecomposedRecipe.builder().with(BuiltinRecipeComponents.Input.INGREDIENTS, recipe.getIngredients().stream().map(IIngredient::fromIngredient).toList()).with(RecipeHandlerUtils.TOOL_COMPONENT, (Object)IIngredient.fromIngredient((Ingredient)recipe.getTool())).with(BuiltinRecipeComponents.Metadata.GROUP, (Object)recipe.getGroup()).with(BuiltinRecipeComponents.Output.CHANCED_ITEMS, recipe.getRollableResults().stream().map(chanceResult -> new MCItemStack(chanceResult.stack()).percent((double)chanceResult.chance())).toList()).build();
        if (recipe.getSoundEvent().isPresent()) {
            decomposedRecipe.set(RecipeHandlerUtils.SOUND_COMPONENT, (Object)recipe.getSoundEvent().get());
        }
        return Optional.of(decomposedRecipe);
    }

    public Optional<CuttingBoardRecipe> recompose(IRecipeManager<? super CuttingBoardRecipe> manager, RegistryAccess registryAccess, IDecomposedRecipe recipe) {
        String group = (String)recipe.getOrThrowSingle(BuiltinRecipeComponents.Metadata.GROUP);
        List ingredients = recipe.getOrThrow(BuiltinRecipeComponents.Input.INGREDIENTS);
        IIngredient tool = (IIngredient)recipe.getOrThrowSingle(RecipeHandlerUtils.TOOL_COMPONENT);
        IIngredient[] ingredientArray = (IIngredient[])ingredients.toArray(IIngredient[]::new);
        List results = recipe.getOrThrow(BuiltinRecipeComponents.Output.CHANCED_ITEMS);
        NonNullList stackedResults = NonNullList.create();
        stackedResults.addAll(results.stream().map(iItemStackPercentaged -> new ChanceResult(((IItemStack)iItemStackPercentaged.getData()).getInternal(), (float)iItemStackPercentaged.getPercentage())).toList());
        List soundList = recipe.get(RecipeHandlerUtils.SOUND_COMPONENT);
        Optional<SoundEvent> sound = soundList == null ? Optional.empty() : Optional.of((SoundEvent)soundList.get(0));
        Ingredient input = ingredientArray[0].asVanillaIngredient();
        return Optional.of(new CuttingBoardRecipe(group, input, tool.asVanillaIngredient(), (NonNullList<ChanceResult>)stackedResults, sound));
    }
}

