/*
 * Decompiled with CFR 0.152.
 */
package com.traverse.bhc.common;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.traverse.bhc.common.config.BHCConfig;
import com.traverse.bhc.common.config.ConfigHandler;
import com.traverse.bhc.common.init.RegistryHandler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLPaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="bhc")
public class BaubleyHeartCanisters {
    public static final String MODID = "bhc";
    private static final Logger LOGGER = LoggerFactory.getLogger(BaubleyHeartCanisters.class);
    public static BHCConfig config;

    public BaubleyHeartCanisters(IEventBus modEventBus, ModContainer modContainer) {
        RegistryHandler.ITEMS.register(modEventBus);
        RegistryHandler.TAB.register(modEventBus);
        RegistryHandler.CONTAINERS.register(modEventBus);
        RegistryHandler.RECIPESERIALIZER.register(modEventBus);
        RegistryHandler.DATA_COMPONENT_TYPES.register(modEventBus);
        modContainer.registerConfig(ModConfig.Type.STARTUP, (IConfigSpec)ConfigHandler.configSpec);
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ConfigHandler.serverConfigSpec);
        modEventBus.addListener(this::setup);
    }

    private void setup(FMLCommonSetupEvent event) {
        this.jsonSetup();
    }

    private void jsonSetup() {
        Path configFile;
        Gson gson;
        block18: {
            gson = new GsonBuilder().setPrettyPrinting().create();
            configFile = FMLPaths.CONFIGDIR.get().resolve(MODID).resolve("drops.json");
            try {
                Files.createDirectories(configFile.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("unable to create %s config directory".formatted(MODID), e);
            }
            try {
                if (!Files.exists(configFile, new LinkOption[0])) break block18;
                try (BufferedReader reader = Files.newBufferedReader(configFile);){
                    config = (BHCConfig)gson.fromJson((Reader)reader, BHCConfig.class);
                }
                return;
            }
            catch (IOException e) {
                LOGGER.error("Unable to read config file", (Throwable)e);
            }
        }
        config = new BHCConfig();
        try (BufferedWriter writer = Files.newBufferedWriter(configFile, new OpenOption[0]);){
            config.addEntrytoMap("red", "hostile", 0.05);
            config.addEntrytoMap("yellow", "boss", 1.0);
            config.addEntrytoMap("green", "dragon", 1.0);
            config.addEntrytoMap("blue", "minecraft:warden", 1.0);
            gson.toJson((Object)config, (Appendable)writer);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write %s config".formatted(MODID), e);
        }
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }
}

