/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.data.worldgen.placement;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.NoiseBasedCountPlacement;
import net.minecraft.world.level.levelgen.placement.NoiseThresholdCountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.SurfaceWaterDepthFilter;
import net.regions_unexplored.data.worldgen.features.RuAquaticFeatures;
import net.regions_unexplored.data.worldgen.features.RuVegetationFeatures;
import net.regions_unexplored.registry.PlacedFeatureRegistry;

public class RuAquaticPlacements {
    public static final ResourceKey<PlacedFeature> CATTAIL_FEN = PlacedFeatureRegistry.createKey("cattail_fen");
    public static final ResourceKey<PlacedFeature> CATTAIL_RIVER = PlacedFeatureRegistry.createKey("cattail_river");
    public static final ResourceKey<PlacedFeature> TALL_HYACINTH_STOCK = PlacedFeatureRegistry.createKey("tall_hyacinth_stock");
    public static final ResourceKey<PlacedFeature> HYACINTH_PLANTS = PlacedFeatureRegistry.createKey("hyacinth_plants");
    public static final ResourceKey<PlacedFeature> HYACINTH_FLOWERS = PlacedFeatureRegistry.createKey("hyacinth_flowers");
    public static final ResourceKey<PlacedFeature> HYACINTH_ROCKS = PlacedFeatureRegistry.createKey("hyacinth_rocks");
    public static final ResourceKey<PlacedFeature> MOSSY_SEA_ROCKS = PlacedFeatureRegistry.createKey("mossy_sea_rocks");
    public static final ResourceKey<PlacedFeature> BLUE_MAGNOLIA_FLOWERS_AQUATIC = PlacedFeatureRegistry.createKey("red_magnolia_flowers_aquatic");
    public static final ResourceKey<PlacedFeature> PINK_MAGNOLIA_FLOWERS_AQUATIC = PlacedFeatureRegistry.createKey("pink_magnolia_flowers_aquatic");
    public static final ResourceKey<PlacedFeature> WHITE_MAGNOLIA_FLOWERS_AQUATIC = PlacedFeatureRegistry.createKey("white_magnolia_flowers_aquatic");
    public static final ResourceKey<PlacedFeature> JUNGLE_TREE_AQUATIC = PlacedFeatureRegistry.createKey("jungle_tree_aquatic");
    public static final ResourceKey<PlacedFeature> PALM_TREE_AQUATIC = PlacedFeatureRegistry.createKey("palm_tree_aquatic");
    public static final ResourceKey<PlacedFeature> ELEPHANT_EAR_AQUATIC = PlacedFeatureRegistry.createKey("elephant_ear_aquatic");
    public static final ResourceKey<PlacedFeature> PALM_SAPLING_AQUATIC = PlacedFeatureRegistry.createKey("palm_sapling_aquatic");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter featureGetter = context.lookup(Registries.CONFIGURED_FEATURE);
        Holder.Reference FEN_CATTAIL = featureGetter.getOrThrow(RuAquaticFeatures.FEN_CATTAIL.get());
        Holder.Reference WATER_CATTAIL = featureGetter.getOrThrow(RuAquaticFeatures.WATER_CATTAIL.get());
        Holder.Reference TALL_HYACINTH_STOCK = featureGetter.getOrThrow(RuAquaticFeatures.TALL_HYACINTH_STOCK.get());
        Holder.Reference HYACINTH_PLANTS = featureGetter.getOrThrow(RuAquaticFeatures.HYACINTH_PLANTS.get());
        Holder.Reference HYACINTH_FLOWERS = featureGetter.getOrThrow(RuAquaticFeatures.HYACINTH_FLOWERS.get());
        Holder.Reference HYACINTH_ROCKS = featureGetter.getOrThrow(RuAquaticFeatures.HYACINTH_ROCKS.get());
        Holder.Reference MOSSY_SEA_ROCKS = featureGetter.getOrThrow(RuAquaticFeatures.MOSSY_SEA_ROCKS.get());
        Holder.Reference BLUE_MAGNOLIA_FLOWERS_AQUATIC = featureGetter.getOrThrow(RuAquaticFeatures.BLUE_MAGNOLIA_FLOWERS_AQUATIC.get());
        Holder.Reference PINK_MAGNOLIA_FLOWERS_AQUATIC = featureGetter.getOrThrow(RuAquaticFeatures.PINK_MAGNOLIA_FLOWERS_AQUATIC.get());
        Holder.Reference WHITE_MAGNOLIA_FLOWERS_AQUATIC = featureGetter.getOrThrow(RuAquaticFeatures.WHITE_MAGNOLIA_FLOWERS_AQUATIC.get());
        Holder.Reference JUNGLE_TREE_AQUATIC = featureGetter.getOrThrow(RuAquaticFeatures.JUNGLE_TREE_AQUATIC.get());
        Holder.Reference PALM_TREE_AQUATIC = featureGetter.getOrThrow(RuAquaticFeatures.PALM_TREE_AQUATIC.get());
        Holder.Reference ELEPHANT_EAR_AQUATIC = featureGetter.getOrThrow(RuAquaticFeatures.ELEPHANT_EAR_AQUATIC.get());
        Holder.Reference PALM_SAPLING_AQUATIC = featureGetter.getOrThrow(RuVegetationFeatures.PALM_SHRUB);
        RuAquaticPlacements.register(context, CATTAIL_FEN, FEN_CATTAIL, List.of(NoiseThresholdCountPlacement.of((double)-0.8, (int)5, (int)24), InSquarePlacement.spread(), SurfaceWaterDepthFilter.forMaxDepth((int)3), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, BiomeFilter.biome()));
        RuAquaticPlacements.register(context, CATTAIL_RIVER, WATER_CATTAIL, List.of(NoiseThresholdCountPlacement.of((double)-0.8, (int)5, (int)6), InSquarePlacement.spread(), SurfaceWaterDepthFilter.forMaxDepth((int)3), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, BiomeFilter.biome()));
        RuAquaticPlacements.register(context, RuAquaticPlacements.TALL_HYACINTH_STOCK, TALL_HYACINTH_STOCK, new PlacementModifier[]{NoiseBasedCountPlacement.of((int)20, (double)80.0, (double)0.3), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, BiomeFilter.biome()});
        RuAquaticPlacements.register(context, RuAquaticPlacements.HYACINTH_PLANTS, HYACINTH_PLANTS, RuAquaticPlacements.seagrassPlacement(80));
        RuAquaticPlacements.register(context, RuAquaticPlacements.HYACINTH_FLOWERS, HYACINTH_FLOWERS, new PlacementModifier[]{CountPlacement.of((int)15), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, BiomeFilter.biome()});
        RuAquaticPlacements.register(context, RuAquaticPlacements.HYACINTH_ROCKS, HYACINTH_ROCKS, new PlacementModifier[]{CountPlacement.of((int)1), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, BiomeFilter.biome()});
        RuAquaticPlacements.register(context, RuAquaticPlacements.MOSSY_SEA_ROCKS, MOSSY_SEA_ROCKS, new PlacementModifier[]{NoiseBasedCountPlacement.of((int)1, (double)80.0, (double)0.3), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, BiomeFilter.biome()});
        RuAquaticPlacements.register(context, RuAquaticPlacements.BLUE_MAGNOLIA_FLOWERS_AQUATIC, BLUE_MAGNOLIA_FLOWERS_AQUATIC, new PlacementModifier[]{CountPlacement.of((int)35), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, BiomeFilter.biome()});
        RuAquaticPlacements.register(context, RuAquaticPlacements.PINK_MAGNOLIA_FLOWERS_AQUATIC, PINK_MAGNOLIA_FLOWERS_AQUATIC, new PlacementModifier[]{CountPlacement.of((int)35), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, BiomeFilter.biome()});
        RuAquaticPlacements.register(context, RuAquaticPlacements.WHITE_MAGNOLIA_FLOWERS_AQUATIC, WHITE_MAGNOLIA_FLOWERS_AQUATIC, new PlacementModifier[]{CountPlacement.of((int)35), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, BiomeFilter.biome()});
        RuAquaticPlacements.register(context, RuAquaticPlacements.JUNGLE_TREE_AQUATIC, JUNGLE_TREE_AQUATIC, List.of(CountPlacement.of((int)24), InSquarePlacement.spread(), SurfaceWaterDepthFilter.forMaxDepth((int)0), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, PlacementUtils.filteredByBlockSurvival((Block)Blocks.OAK_SAPLING), BiomeFilter.biome()));
        RuAquaticPlacements.register(context, RuAquaticPlacements.PALM_TREE_AQUATIC, PALM_TREE_AQUATIC, List.of(CountPlacement.of((int)15), InSquarePlacement.spread(), SurfaceWaterDepthFilter.forMaxDepth((int)0), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, PlacementUtils.filteredByBlockSurvival((Block)Blocks.OAK_SAPLING), BiomeFilter.biome()));
        RuAquaticPlacements.register(context, RuAquaticPlacements.PALM_SAPLING_AQUATIC, PALM_SAPLING_AQUATIC, List.of(CountPlacement.of((int)5), InSquarePlacement.spread(), SurfaceWaterDepthFilter.forMaxDepth((int)0), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, PlacementUtils.filteredByBlockSurvival((Block)Blocks.OAK_SAPLING), BiomeFilter.biome()));
        RuAquaticPlacements.register(context, RuAquaticPlacements.ELEPHANT_EAR_AQUATIC, ELEPHANT_EAR_AQUATIC, List.of(CountPlacement.of((int)8), InSquarePlacement.spread(), SurfaceWaterDepthFilter.forMaxDepth((int)0), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, PlacementUtils.filteredByBlockSurvival((Block)Blocks.OAK_SAPLING), BiomeFilter.biome()));
    }

    private static List<PlacementModifier> seagrassPlacement(int count) {
        return List.of(InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_TOP_SOLID, CountPlacement.of((int)count), BiomeFilter.biome());
    }

    protected static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> feature, PlacementModifier ... placement) {
        RuAquaticPlacements.register(context, key, feature, List.of(placement));
    }

    protected static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> feature, List<PlacementModifier> placement) {
        context.register(key, (Object)new PlacedFeature(feature, placement));
    }
}

