/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.block.plant.dusktrap;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.regions_unexplored.entity.RuDamageTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseDuskTrapBlock
extends DoublePlantBlock {
    protected static final VoxelShape CLOSED_AABB = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape AABB = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    protected static final AABB TOUCH_AABB = new AABB(0.3, 0.0, 0.3, 0.7, 16.0, 0.7);

    protected BaseDuskTrapBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter blockGetter, @NotNull BlockPos blockPos, @NotNull CollisionContext collisionContext) {
        return this.getSignalForState(state) > 0 ? CLOSED_AABB : AABB;
    }

    protected int getClosedTime() {
        return 5;
    }

    public boolean isPossibleToRespawnInThis(@NotNull BlockState blockState) {
        return true;
    }

    public void tick(@NotNull BlockState blockState, @NotNull ServerLevel serverLevel, @NotNull BlockPos blockPos, @NotNull RandomSource randomSource) {
        int i = this.getSignalForState(blockState);
        if (i > 0) {
            this.checkClosed(null, (Level)serverLevel, blockPos, blockState, i);
        }
    }

    public void entityInside(@NotNull BlockState state, @NotNull Level level, BlockPos pos, Entity entity) {
        Vec3 entityPos = entity.position();
        Vec3 inPos = new Vec3((double)pos.getX() + 0.002, (double)pos.getY(), (double)pos.getZ() + 0.002);
        Vec3 outPos = new Vec3((double)pos.getX() + 0.998, (double)pos.getY(), (double)pos.getZ() + 0.998);
        boolean isInside = entityPos.x > inPos.x && entityPos.z > inPos.z && entityPos.x < outPos.x && entityPos.z < outPos.z;
        boolean isItem = entity instanceof ItemEntity;
        if (!isItem && isInside) {
            entity.makeStuckInBlock(state, new Vec3(0.4, 0.1, 0.4));
        }
        if (!level.isClientSide && entity instanceof LivingEntity) {
            if (entity.isAlive() && isInside) {
                entity.hurt(level.damageSources().source(RuDamageTypes.DUSK_TRAP), 3.0f);
            }
            entity.makeStuckInBlock(state, new Vec3(0.4, 0.1, 0.4));
            int i = this.getSignalForState(state);
            if (i == 0) {
                this.checkClosed(entity, level, pos, state, i);
            }
        }
    }

    private void checkClosed(@Nullable Entity entity, Level level, BlockPos pos, BlockState state, int power) {
        boolean flag1;
        int i = this.getSignalStrength(level, pos);
        boolean flag = power > 0;
        boolean bl = flag1 = i > 0;
        if (power != i) {
            BlockState blockstate = this.setSignalForState(state, i);
            if (blockstate.getValue((Property)HALF) == DoubleBlockHalf.LOWER) {
                BlockPos blockpos = pos.above();
                level.setBlock(blockpos, (BlockState)blockstate.setValue((Property)HALF, (Comparable)DoubleBlockHalf.UPPER), 2);
            } else if (blockstate.getValue((Property)HALF) == DoubleBlockHalf.UPPER) {
                BlockPos blockpos = pos.below();
                level.setBlock(blockpos, (BlockState)blockstate.setValue((Property)HALF, (Comparable)DoubleBlockHalf.LOWER), 2);
            }
            level.setBlock(pos, blockstate, 2);
            this.updateNeighbours(level, pos);
            level.setBlocksDirty(pos, state, blockstate);
        }
        if (!flag1 && flag) {
            level.playSound((Player)null, pos, SoundType.TWISTING_VINES.getBreakSound(), SoundSource.BLOCKS);
            level.gameEvent(entity, (Holder)GameEvent.BLOCK_DEACTIVATE, pos);
        } else if (flag1 && !flag) {
            level.playSound((Player)null, pos, SoundType.TWISTING_VINES.getPlaceSound(), SoundSource.BLOCKS);
            level.gameEvent(entity, (Holder)GameEvent.BLOCK_ACTIVATE, pos);
        }
        if (flag1) {
            level.scheduleTick(new BlockPos((Vec3i)pos), (Block)this, this.getClosedTime());
        }
    }

    public void onRemove(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState blockState1, boolean bool) {
        if (!bool && !blockState.is(blockState1.getBlock())) {
            if (this.getSignalForState(blockState) > 0) {
                this.updateNeighbours(level, blockPos);
            }
            super.onRemove(blockState, level, blockPos, blockState1, bool);
        }
    }

    protected void updateNeighbours(Level level, BlockPos blockPos) {
        level.updateNeighborsAt(blockPos, (Block)this);
        level.updateNeighborsAt(blockPos.below(), (Block)this);
    }

    public int getSignal(@NotNull BlockState blockState, @NotNull BlockGetter blockGetter, @NotNull BlockPos blockPos, @NotNull Direction direction) {
        return this.getSignalForState(blockState);
    }

    public int getDirectSignal(@NotNull BlockState blockState, @NotNull BlockGetter blockGetter, @NotNull BlockPos blockPos, @NotNull Direction direction) {
        return direction == Direction.UP ? this.getSignalForState(blockState) : 0;
    }

    public boolean isSignalSource(@NotNull BlockState p_49351_) {
        return true;
    }

    protected static int getEntityCount(Level level, AABB aabb, Class<? extends Entity> entity) {
        return level.getEntitiesOfClass(entity, aabb, EntitySelector.NO_SPECTATORS.and(e -> !e.isIgnoringBlockTriggers())).size();
    }

    protected abstract int getSignalStrength(Level var1, BlockPos var2);

    protected abstract int getSignalForState(BlockState var1);

    protected abstract BlockState setSignalForState(BlockState var1, int var2);
}

