/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.regions_unexplored.block.RuBlocks;

public class HangingEarlightFeature
extends Feature<NoneFeatureConfiguration> {
    private static final Direction[] DIRECTIONS = Direction.values();

    public HangingEarlightFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        RandomSource random = context.random();
        if (!level.isEmptyBlock(pos)) {
            return false;
        }
        BlockState blockstate = level.getBlockState(pos.above());
        if (!blockstate.is(Blocks.BLACKSTONE) && !blockstate.is(RuBlocks.COBALT_OBSIDIAN.get())) {
            return false;
        }
        this.placeRoofCobaltObsidian((LevelAccessor)level, random, pos);
        this.placeRoofHangingEarlight((LevelAccessor)level, random, pos);
        return true;
    }

    private void placeRoofCobaltObsidian(LevelAccessor level, RandomSource random, BlockPos pos) {
        level.setBlock(pos, RuBlocks.COBALT_OBSIDIAN.get().defaultBlockState(), 2);
        BlockPos.MutableBlockPos pos1 = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos pos2 = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 200; ++i) {
            pos1.setWithOffset((Vec3i)pos, random.nextInt(6) - random.nextInt(6), random.nextInt(2) - random.nextInt(5), random.nextInt(6) - random.nextInt(6));
            if (!level.isEmptyBlock((BlockPos)pos1)) continue;
            int j = 0;
            for (Direction direction : DIRECTIONS) {
                BlockState blockstate = level.getBlockState((BlockPos)pos2.setWithOffset((Vec3i)pos1, direction));
                if (blockstate.is(Blocks.NETHERRACK) || blockstate.is(RuBlocks.COBALT_OBSIDIAN.get())) {
                    ++j;
                }
                if (j > 1) break;
            }
            if (j != true) continue;
            level.setBlock((BlockPos)pos1, RuBlocks.COBALT_OBSIDIAN.get().defaultBlockState(), 2);
        }
    }

    private void placeRoofHangingEarlight(LevelAccessor level, RandomSource random, BlockPos pos) {
        BlockPos.MutableBlockPos pos1 = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 100; ++i) {
            BlockState blockstate;
            pos1.setWithOffset((Vec3i)pos, random.nextInt(8) - random.nextInt(8), random.nextInt(2) - random.nextInt(7), random.nextInt(8) - random.nextInt(8));
            if (!level.isEmptyBlock((BlockPos)pos1) || !(blockstate = level.getBlockState(pos1.above())).is(Blocks.NETHERRACK) && !blockstate.is(RuBlocks.COBALT_OBSIDIAN.get())) continue;
            int j = Mth.nextInt((RandomSource)random, (int)1, (int)19);
            if (random.nextInt(6) == 0) {
                j *= 2;
            }
            if (random.nextInt(5) == 0) {
                j = 1;
            }
            HangingEarlightFeature.placeHangingEarlightColumn(level, random, pos1, j, 10, 19);
        }
    }

    public static void placeHangingEarlightColumn(LevelAccessor level, RandomSource random, BlockPos.MutableBlockPos pos, int length, int low, int high) {
        for (int i = 0; i <= length; ++i) {
            if (level.isEmptyBlock((BlockPos)pos)) {
                if (i == length || !level.isEmptyBlock(pos.below())) {
                    level.setBlock((BlockPos)pos, (BlockState)RuBlocks.HANGING_EARLIGHT.get().defaultBlockState().setValue((Property)GrowingPlantHeadBlock.AGE, (Comparable)Integer.valueOf(Mth.nextInt((RandomSource)random, (int)low, (int)high))), 2);
                    break;
                }
                level.setBlock((BlockPos)pos, RuBlocks.HANGING_EARLIGHT_PLANT.get().defaultBlockState(), 2);
            }
            pos.move(Direction.DOWN);
        }
    }
}

