/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.data.tags.RuTags;
import net.regions_unexplored.world.level.block.plant.aquatic.TallHyacinthStockBlock;
import net.regions_unexplored.world.level.block.state.properties.TallHyacinthStockShape;
import net.regions_unexplored.world.level.feature.configuration.HyacinthStockConfiguration;

public class HyacinthStockFeature
extends Feature<HyacinthStockConfiguration> {
    public HyacinthStockFeature(Codec<HyacinthStockConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<HyacinthStockConfiguration> context) {
        HyacinthStockConfiguration stockConfiguration = (HyacinthStockConfiguration)context.config();
        BlockPos pos = context.origin();
        RandomSource randomSource = context.random();
        WorldGenLevel level = context.level();
        int height_main = context.random().nextInt(stockConfiguration.sizeVariation) + stockConfiguration.minimumSize;
        if (!level.getBlockState(pos.below()).isFaceSturdy((BlockGetter)level, pos, Direction.UP)) {
            return false;
        }
        BlockPos.MutableBlockPos placePos = pos.mutable();
        for (int placeCheck = 0; placeCheck <= height_main && level.getBlockState((BlockPos)placePos).is(Blocks.WATER); ++placeCheck) {
            this.placePlant((LevelAccessor)level, (BlockPos)placePos, randomSource, stockConfiguration);
            placePos.move(Direction.UP);
        }
        return true;
    }

    public boolean placePlant(LevelAccessor level, BlockPos pos, RandomSource randomSource, HyacinthStockConfiguration stockConfiguration) {
        Random random = new Random();
        if (level.isOutsideBuildHeight(pos)) {
            return true;
        }
        if (!level.getBlockState(pos.below()).is(RuBlocks.TALL_HYACINTH_STOCK.get())) {
            level.setBlock(pos, stockConfiguration.stockProvider.getState(randomSource, pos), 2);
        }
        if (level.getBlockState(pos.below()) == RuBlocks.TALL_HYACINTH_STOCK.get().defaultBlockState()) {
            level.setBlock(pos, (BlockState)stockConfiguration.stockProvider.getState(randomSource, pos).setValue(TallHyacinthStockBlock.SHAPE, (Comparable)((Object)TallHyacinthStockShape.TIP)), 2);
            level.setBlock(pos.below(), (BlockState)stockConfiguration.stockProvider.getState(randomSource, pos.below()).setValue(TallHyacinthStockBlock.SHAPE, (Comparable)((Object)TallHyacinthStockShape.BASE_FRUSTUM)), 2);
        }
        if (level.getBlockState(pos.below().below()) == RuBlocks.TALL_HYACINTH_STOCK.get().defaultBlockState().setValue(TallHyacinthStockBlock.SHAPE, (Comparable)((Object)TallHyacinthStockShape.BASE_FRUSTUM))) {
            level.setBlock(pos, (BlockState)stockConfiguration.stockProvider.getState(randomSource, pos).setValue(TallHyacinthStockBlock.SHAPE, (Comparable)((Object)TallHyacinthStockShape.TIP)), 2);
            level.setBlock(pos.below(), (BlockState)stockConfiguration.stockProvider.getState(randomSource, pos.below()).setValue(TallHyacinthStockBlock.SHAPE, (Comparable)((Object)TallHyacinthStockShape.FRUSTUM)), 2);
            level.setBlock(pos.below().below(), (BlockState)stockConfiguration.stockProvider.getState(randomSource, pos.below().below()).setValue(TallHyacinthStockBlock.SHAPE, (Comparable)((Object)TallHyacinthStockShape.BASE)), 2);
        }
        if (level.getBlockState(pos.below().below()) == RuBlocks.TALL_HYACINTH_STOCK.get().defaultBlockState().setValue(TallHyacinthStockBlock.SHAPE, (Comparable)((Object)TallHyacinthStockShape.FRUSTUM))) {
            level.setBlock(pos, (BlockState)stockConfiguration.stockProvider.getState(randomSource, pos).setValue(TallHyacinthStockBlock.SHAPE, (Comparable)((Object)TallHyacinthStockShape.TIP)), 2);
            level.setBlock(pos.below(), (BlockState)stockConfiguration.stockProvider.getState(randomSource, pos.below()).setValue(TallHyacinthStockBlock.SHAPE, (Comparable)((Object)TallHyacinthStockShape.FRUSTUM)), 2);
            level.setBlock(pos.below().below(), (BlockState)stockConfiguration.stockProvider.getState(randomSource, pos.below().below()).setValue(TallHyacinthStockBlock.SHAPE, (Comparable)((Object)TallHyacinthStockShape.MIDDLE)), 2);
        }
        return true;
    }

    public static boolean isReplaceableDirtBlock(BlockState state) {
        return state.is(RuTags.TREE_GRASS_REPLACEABLES);
    }

    public static boolean isReplaceableDirt(LevelSimulatedReader reader, BlockPos pos) {
        return reader.isStateAtPosition(pos, HyacinthStockFeature::isReplaceableDirtBlock);
    }

    public static boolean isReplaceableBlock(BlockState state) {
        return state.is(RuTags.REPLACEABLE_BLOCKS);
    }

    public static boolean isReplaceable(LevelSimulatedReader reader, BlockPos pos) {
        return reader.isStateAtPosition(pos, HyacinthStockFeature::isReplaceableBlock);
    }
}

