/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.mixin;

import artifacts.registry.ModItems;
import it.hurts.octostudios.rarcompat.items.hat.VillagerHatItem;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractVillager.class})
abstract class AbstractVillagerMixin {
    @Shadow
    private Player tradingPlayer;
    @Shadow
    protected MerchantOffers offers;

    AbstractVillagerMixin() {
    }

    @Inject(method={"notifyTrade "}, at={@At(value="HEAD")})
    private void notifyTrade(MerchantOffer offer, CallbackInfo ci) {
        VillagerHatItem relic;
        ItemStack relicStack;
        block5: {
            block4: {
                relicStack = EntityUtils.findEquippedCurio((Entity)this.tradingPlayer, (Item)((Item)ModItems.VILLAGER_HAT.value()));
                Item item = relicStack.getItem();
                if (!(item instanceof VillagerHatItem)) break block4;
                relic = (VillagerHatItem)item;
                if (this.offers != null && relic.isAbilityUnlocked(relicStack, "discount")) break block5;
            }
            return;
        }
        int newPrice = (int)Math.round((double)offer.getItemCostA().count() * relic.getStatValue(relicStack, "discount", "multiplier"));
        if (newPrice > 1) {
            relic.spreadRelicExperience((LivingEntity)this.tradingPlayer, relicStack, 1 + this.tradingPlayer.getRandom().nextInt(newPrice) + 1);
        }
    }

    @Inject(method={"getOffers"}, at={@At(value="HEAD")})
    private void getOffers(CallbackInfoReturnable<MerchantOffers> cir) {
        VillagerHatItem relic;
        ItemStack relicStack;
        block4: {
            block3: {
                relicStack = EntityUtils.findEquippedCurio((Entity)this.tradingPlayer, (Item)((Item)ModItems.VILLAGER_HAT.value()));
                Item item = relicStack.getItem();
                if (!(item instanceof VillagerHatItem)) break block3;
                relic = (VillagerHatItem)item;
                if (this.offers != null && relic.isAbilityUnlocked(relicStack, "discount")) break block4;
            }
            return;
        }
        for (MerchantOffer offer : this.offers) {
            int newPrice = (int)Math.round((double)offer.getItemCostA().count() * relic.getStatValue(relicStack, "discount", "multiplier") / 100.0);
            offer.setSpecialPriceDiff(-newPrice);
        }
    }
}

