/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.pocketstorage.commands;

import com.flanks255.pocketstorage.PocketStorage;
import com.flanks255.pocketstorage.inventory.PSUData;
import com.flanks255.pocketstorage.inventory.StorageManager;
import com.flanks255.pocketstorage.util.PSUtils;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class Recover {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"recover").requires(cs -> cs.hasPermission(1))).then(Commands.argument((String)"UUID", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.suggest(PSUtils.getUUIDSuggestions((CommandContext<CommandSourceStack>)context), (SuggestionsBuilder)builder)).executes(cs -> Recover.recover((CommandContext<CommandSourceStack>)cs, StringArgumentType.getString((CommandContext)cs, (String)"UUID"))));
    }

    public static int recover(CommandContext<CommandSourceStack> ctx, String stringUUID) throws CommandSyntaxException {
        UUID uuid;
        try {
            uuid = UUID.fromString(stringUUID);
        }
        catch (IllegalArgumentException e) {
            return 0;
        }
        StorageManager storage = StorageManager.get();
        if (storage.getMap().containsKey(uuid)) {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            Optional<PSUData> data = storage.getStorage(uuid);
            data.ifPresent(psu -> {
                ItemStack stack = new ItemStack((ItemLike)psu.getTier().item.get());
                stack.set((DataComponentType)PocketStorage.PSU_UUID.get(), (Object)psu.getUuid());
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack);
            });
        } else {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"pocketstorage.util.invalid_uuid"));
        }
        return 0;
    }
}

