/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.network.packets;

import com.pedrorok.hypertube.core.travel.TravelManager;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record ActionPointReachPacket(UUID entityId, BlockPos pos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ActionPointReachPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"create_hypertube", (String)"entity_action_point_reach"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ActionPointReachPacket> STREAM_CODEC = StreamCodec.of(ActionPointReachPacket::encode, ActionPointReachPacket::decode);

    public static void encode(FriendlyByteBuf buf, ActionPointReachPacket packet) {
        buf.writeUUID(packet.entityId);
        buf.writeBlockPos(packet.pos);
    }

    public static ActionPointReachPacket decode(FriendlyByteBuf buf) {
        UUID id = buf.readUUID();
        BlockPos pos = buf.readBlockPos();
        return new ActionPointReachPacket(id, pos);
    }

    public static void handle(ActionPointReachPacket packet, IPayloadContext ctx) {
        ctx.enqueueWork(() -> TravelManager.actionPointReach(packet.entityId, packet.pos));
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

