/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.compat.mi.guicomponent.configurationpanel;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.swedz.tesseract.neoforge.compat.mi.guicomponent.configurationpanel.ConfigurationPanel;

public final class ConfigurationPanelBuilder {
    private final Component title;
    private final Component description;
    private final ClickHandler handleClick;
    private final List<Line> lines = Lists.newArrayList();

    public ConfigurationPanelBuilder(Component title, Component description, ClickHandler handleClick) {
        this.title = title;
        this.description = description;
        this.handleClick = handleClick;
    }

    public ConfigurationPanelBuilder(Component title, Component description) {
        this(title, description, null);
    }

    public ConfigurationPanelBuilder add(List<Component> translations, boolean useArrows, LineClickHandler handleClickAction, CurrentIndexSupplier currentIndexGetter) {
        this.lines.add(new Line(translations, useArrows, handleClickAction, currentIndexGetter));
        return this;
    }

    public ConfigurationPanel build() {
        return new ConfigurationPanel(new ConfigurationPanel.Behavior(){

            @Override
            public void handleClick(int lineIndex, int delta) {
                ConfigurationPanelBuilder.this.lines.get(lineIndex).handleClick(delta);
                if (ConfigurationPanelBuilder.this.handleClick != null) {
                    ConfigurationPanelBuilder.this.handleClick.handleClick(lineIndex, delta);
                }
            }

            @Override
            public int getCurrentIndex(int lineIndex) {
                return ConfigurationPanelBuilder.this.lines.get(lineIndex).getCurrentIndex();
            }
        }, this.title, this.description, (ConfigurationPanel.LineInfo[])this.lines.stream().map(line -> new ConfigurationPanel.LineInfo(line.translations(), line.useArrows())).toArray(ConfigurationPanel.LineInfo[]::new));
    }

    public static interface ClickHandler {
        public void handleClick(int var1, int var2);
    }

    private record Line(List<Component> translations, boolean useArrows, LineClickHandler handleClickAction, CurrentIndexSupplier currentIndexGetter) {
        public int numValues() {
            return this.translations.size();
        }

        public void handleClick(int delta) {
            this.handleClickAction.handleClick(delta);
        }

        public int getCurrentIndex() {
            return this.currentIndexGetter.getCurrentIndex();
        }
    }

    public static interface LineClickHandler {
        public void handleClick(int var1);
    }

    public static interface CurrentIndexSupplier {
        public int getCurrentIndex();
    }
}

