/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.compat.mi.machine.builder.slots;

import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import java.util.function.Supplier;
import net.minecraft.world.level.material.Fluid;
import net.swedz.tesseract.neoforge.api.Assert;
import net.swedz.tesseract.neoforge.compat.mi.machine.builder.slots.MachineSlotDefinition;
import net.swedz.tesseract.neoforge.compat.mi.mixin.accessor.ConfigurableStackAccessor;

public final class FluidMachineSlotDefinition
extends MachineSlotDefinition<Fluid, FluidVariant> {
    private final long capacity;

    public FluidMachineSlotDefinition(int x, int y, boolean playerInsert, boolean pipesInsert, boolean playerExtract, boolean pipesExtract, Supplier<Fluid> lock, long capacity) {
        super(x, y, playerInsert, pipesInsert, playerExtract, pipesExtract, lock);
        Assert.that(capacity > 0L, "Capacity must be > 0");
        this.capacity = capacity;
    }

    public long capacity() {
        return this.capacity;
    }

    public ConfigurableFluidStack create() {
        ConfigurableFluidStack stack = new ConfigurableFluidStack(this.capacity);
        ConfigurableStackAccessor access = (ConfigurableStackAccessor)stack;
        access.setLockedInstance((Fluid)this.lock());
        access.setPlayerLockable(!this.hasLock());
        access.setPlayerLocked(this.hasLock());
        access.setPlayerInsert(this.playerInsert);
        access.setPipesInsert(this.pipesInsert);
        access.setPlayerExtract(this.playerExtract);
        access.setPipesExtract(this.pipesExtract);
        return stack;
    }
}

