/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.compat.mi.material.part;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MICommonProxy;
import aztech.modern_industrialization.MITags;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.blocks.storage.StorageBehaviour;
import aztech.modern_industrialization.blocks.storage.barrel.BarrelBlock;
import aztech.modern_industrialization.blocks.storage.barrel.BarrelBlockEntity;
import aztech.modern_industrialization.blocks.storage.barrel.BarrelItem;
import aztech.modern_industrialization.blocks.storage.tank.TankBlock;
import aztech.modern_industrialization.blocks.storage.tank.TankBlockEntity;
import aztech.modern_industrialization.blocks.storage.tank.TankItem;
import aztech.modern_industrialization.datagen.model.DelegatingModelBuilder;
import aztech.modern_industrialization.items.ContainerItem;
import aztech.modern_industrialization.items.ForgeTool;
import aztech.modern_industrialization.items.PortableStorageUnit;
import aztech.modern_industrialization.nuclear.IsotopeParams;
import aztech.modern_industrialization.nuclear.NeutronBehaviour;
import aztech.modern_industrialization.nuclear.NuclearConstant;
import aztech.modern_industrialization.nuclear.NuclearFuel;
import aztech.modern_industrialization.pipes.api.PipeNetworkData;
import aztech.modern_industrialization.pipes.api.PipeNetworkType;
import aztech.modern_industrialization.pipes.electricity.ElectricityNetwork;
import aztech.modern_industrialization.pipes.electricity.ElectricityNetworkData;
import aztech.modern_industrialization.pipes.electricity.ElectricityNetworkNode;
import aztech.modern_industrialization.pipes.impl.PipeItem;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.bridge.SlotFluidHandler;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.bridge.SlotItemHandler;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.base.SingleSlotStorage;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.swedz.tesseract.neoforge.capabilities.CapabilitiesListeners;
import net.swedz.tesseract.neoforge.compat.mi.material.property.IsotopeFuel;
import net.swedz.tesseract.neoforge.compat.mi.material.property.MIMaterialProperties;
import net.swedz.tesseract.neoforge.material.builtin.part.CommonMaterialPartRegisters;
import net.swedz.tesseract.neoforge.material.builtin.part.MaterialParts;
import net.swedz.tesseract.neoforge.material.builtin.property.MaterialProperties;
import net.swedz.tesseract.neoforge.material.part.MaterialPart;
import net.swedz.tesseract.neoforge.material.part.MaterialPartItemFactory;
import net.swedz.tesseract.neoforge.material.part.MaterialPartItemReferenceFormatter;
import net.swedz.tesseract.neoforge.material.part.RegisteredMaterialPart;
import net.swedz.tesseract.neoforge.material.property.MaterialProperty;
import net.swedz.tesseract.neoforge.registry.common.CommonLootTableBuilders;
import net.swedz.tesseract.neoforge.registry.common.CommonModelBuilders;
import net.swedz.tesseract.neoforge.registry.holder.BlockWithItemHolder;

public interface MIMaterialParts {
    public static final MaterialPart BATTERY = MIMaterialParts.create("battery", "Battery").itemModelBuilder(CommonModelBuilders::generated).item((context, holder) -> {
        long batteryCapacity = context.getOrThrow(MIMaterialProperties.BATTERY_CAPACITY);
        if (batteryCapacity <= 0L) {
            throw new IllegalArgumentException("Battery capacity must be > 0");
        }
        holder.withRegistrationListener(item -> PortableStorageUnit.CAPACITY_PER_BATTERY.put(item, batteryCapacity));
    });
    public static final MaterialPart BARREL = MIMaterialParts.create("barrel", "Barrel").blockModel(b -> provider -> {
        Object block = b.get();
        String id = BuiltInRegistries.BLOCK.getKey(block).getPath();
        provider.simpleBlock(block, (ModelFile)provider.models().cubeColumn(id, provider.modLoc("block/%s_side".formatted(id)), provider.modLoc("block/%s_top".formatted(id))));
    }).itemModelBuilder(CommonModelBuilders::itemBlockEntity).itemTag(MITags.BARRELS).withRegister(context -> {
        AtomicReference bet = new AtomicReference();
        BarrelBlock.BarrelStorage storageBehaviour = BarrelBlock.withStackCapacity((long)context.getOrThrow(MIMaterialProperties.BARREL_CAPACITY));
        EntityBlock factory = (pos, state) -> new BarrelBlockEntity((BlockEntityType)bet.get(), pos, state);
        BlockWithItemHolder<Block, BlockItem> blockHolder = new BlockWithItemHolder<Block, BlockItem>(context.id(), context.englishName(), context.registry().blockRegistry(), arg_0 -> MIMaterialParts.lambda$static$5(factory, (StorageBehaviour)storageBehaviour, arg_0), context.registry().itemRegistry(), (b, p) -> new BarrelItem((BarrelBlock)b, p));
        RegisteredMaterialPart registered = RegisteredMaterialPart.existingBlock(blockHolder);
        context.register(blockHolder);
        context.registry().blockEntityRegistry().register(context.id().getPath(), () -> {
            bet.set(BlockEntityType.Builder.of((arg_0, arg_1) -> ((EntityBlock)factory).newBlockEntity(arg_0, arg_1), (Block[])new Block[]{blockHolder.get()}).build(null));
            return (BlockEntityType)bet.get();
        });
        CapabilitiesListeners.register(context.registry().modId(), event -> event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)bet.get(), (be, side) -> new SlotItemHandler((SingleSlotStorage)be)));
        MICommonProxy.INSTANCE.registerPartBarrelClient(bet::get, context.get(MaterialProperties.MEAN_RGB).intValue());
        return registered;
    });
    public static final MaterialPart BLADE = MIMaterialParts.create("blade", "Blade").itemModelBuilder(CommonModelBuilders::generated);
    public static final MaterialPart BOLT = MIMaterialParts.create("bolt", "Bolt").itemModelBuilder(CommonModelBuilders::generated);
    public static final MaterialPart CABLE = MIMaterialParts.create("cable", "Cable").itemFactory((c, p) -> {
        CableTier tier = c.getOrThrow(MIMaterialProperties.CABLE_TIER);
        String cableId = "%s_cable".formatted(c.material().id());
        PipeNetworkType type = PipeNetworkType.register((ResourceLocation)c.registry().id(cableId), (id, data) -> new ElectricityNetwork(id.intValue(), data, tier), ElectricityNetworkNode::new, (int)(c.get(MaterialProperties.MEAN_RGB) | 0xFF000000), (boolean)false);
        return new PipeItem(p, type, (PipeNetworkData)new ElectricityNetworkData());
    }).itemModel(i -> provider -> ((DelegatingModelBuilder)((ItemModelBuilder)provider.getBuilder(BuiltInRegistries.ITEM.getKey(i.get()).getPath())).customLoader(DelegatingModelBuilder::new)).delegate((ModelFile)provider.getExistingFile(MI.id((String)"block/pipe"))).end());
    public static final MaterialPart COIL = MIMaterialParts.create("coil", "Coil").blockModel(CommonModelBuilders::blockTopEnd).blockLoot(CommonLootTableBuilders::self);
    public static final MaterialPart CRUSHED_DUST = MIMaterialParts.create("crushed_dust", "Crushed Dust").itemModelBuilder(CommonModelBuilders::generated);
    public static final MaterialPart CURVED_PLATE = MIMaterialParts.create("curved_plate", "Curved Plate").itemModelBuilder(CommonModelBuilders::generated);
    public static final MaterialPart DOUBLE_INGOT = MIMaterialParts.create("double_ingot", "Double Ingot").itemModelBuilder(CommonModelBuilders::generated);
    public static final MaterialPart DRILL_HEAD = MIMaterialParts.create("drill_head", "Drill Head").itemModelBuilder(CommonModelBuilders::generated);
    public static final MaterialPart DRILL = MIMaterialParts.create("drill", "Drill").itemModelBuilder(CommonModelBuilders::generated);
    public static final MaterialPart FINE_WIRE = MIMaterialParts.create("fine_wire", "Fine Wire").itemModelBuilder(CommonModelBuilders::generated);
    public static final MaterialPart GEAR = ((MaterialPart)MIMaterialParts.create("gear", "Gear").set((MaterialProperty)MaterialProperties.ITEM_REFERENCE, MaterialPartItemReferenceFormatter.tag())).itemModelBuilder(CommonModelBuilders::generated).item(CommonMaterialPartRegisters.itemTagCommon("gears"));
    public static final MaterialPart HAMMER = MIMaterialParts.create("hammer", "Hammer").itemFactory((c, p) -> new ForgeTool(c.get(MaterialProperties.TOOL_TIER), p)).itemModelBuilder(CommonModelBuilders::generated).itemTag(ForgeTool.TAG);
    public static final MaterialPart HOT_INGOT = MIMaterialParts.create("hot_ingot", "Hot Ingot").itemModelBuilder(CommonModelBuilders::generated);
    public static final MaterialPart LARGE_PLATE = MIMaterialParts.create("large_plate", "Large Plate").itemModelBuilder(CommonModelBuilders::generated);
    public static final MaterialPart MACHINE_CASING = MIMaterialParts.create("machine_casing", "Machine Casing").blockModel(CommonModelBuilders::blockCubeAll).blockLoot(CommonLootTableBuilders::self);
    public static final MaterialPart MACHINE_CASING_PIPE = MIMaterialParts.create("machine_casing_pipe", "Pipe Machine Casing").blockModel(CommonModelBuilders::blockCubeAll).blockLoot(CommonLootTableBuilders::self);
    public static final MaterialPart MACHINE_CASING_SPECIAL = MIMaterialParts.create("machine_casing_special", "Special Casing").blockModel(CommonModelBuilders::blockCubeAll).blockLoot(CommonLootTableBuilders::self);
    public static final MaterialPart PLATED_BRICKS = MACHINE_CASING_SPECIAL.formattingMaterialOnly(arg_0 -> MIMaterialParts.lambda$static$16("%s_plated_bricks", arg_0), arg_0 -> MIMaterialParts.lambda$static$17("%s Plated Bricks", arg_0));
    public static final MaterialPart CLEAN_MACHINE_CASING = MACHINE_CASING_SPECIAL.formattingMaterialOnly(arg_0 -> MIMaterialParts.lambda$static$18("clean_%s_machine_casing", arg_0), arg_0 -> MIMaterialParts.lambda$static$19("Clean %s Machine Casing", arg_0));
    public static final MaterialPart SOLID_MACHINE_CASING = MACHINE_CASING_SPECIAL.formattingMaterialOnly(arg_0 -> MIMaterialParts.lambda$static$20("solid_%s_machine_casing", arg_0), arg_0 -> MIMaterialParts.lambda$static$21("Solid %s Machine Casing", arg_0));
    public static final MaterialPart PLASMA_HANDLING_MACHINE_CASING = MACHINE_CASING_SPECIAL.formattingMaterialOnly(arg_0 -> MIMaterialParts.lambda$static$22("plasma_handling_%s_machine_casing", arg_0), arg_0 -> MIMaterialParts.lambda$static$23("Plasma Handling %s Machine Casing", arg_0));
    public static final MaterialPart PLATE = ((MaterialPart)MIMaterialParts.create("plate", "Plate").set((MaterialProperty)MaterialProperties.ITEM_REFERENCE, MaterialPartItemReferenceFormatter.tag())).itemModelBuilder(CommonModelBuilders::generated).item(CommonMaterialPartRegisters.itemTagCommon("plates"));
    public static final MaterialPart RING = MIMaterialParts.create("ring", "Ring").itemModelBuilder(CommonModelBuilders::generated);
    public static final MaterialPart ROD = ((MaterialPart)MIMaterialParts.create("rod", "Rod").set((MaterialProperty)MaterialProperties.ITEM_REFERENCE, MaterialPartItemReferenceFormatter.tag())).itemModelBuilder(CommonModelBuilders::generated).item(CommonMaterialPartRegisters.itemTagCommon("rods"));
    public static final MaterialPart ROD_MAGNETIC = MIMaterialParts.create("rod_magnetic", "Magnetic Rod").formatting((arg_0, arg_1) -> MIMaterialParts.lambda$static$24("%s_%s", arg_0, arg_1), (m, p) -> "Magnetic %s Rod".formatted(m)).itemModelBuilder(CommonModelBuilders::generated);
    public static final MaterialPart ROTOR = MIMaterialParts.create("rotor", "Rotor").itemModelBuilder(CommonModelBuilders::generated);
    public static final MaterialPart TANK = MIMaterialParts.create("tank", "Tank").blockModel(b -> provider -> {
        Object block = b.get();
        provider.simpleBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder(provider.blockTexture(block).getPath())).parent((ModelFile)provider.models().getExistingFile(provider.modLoc("base/tank")))).texture("0", provider.blockTexture(block).toString()));
    }).itemModelBuilder(CommonModelBuilders::itemBlockEntity).itemTag(MITags.TANKS).withRegister(context -> {
        AtomicReference bet = new AtomicReference();
        StorageBehaviour storageBehaviour = StorageBehaviour.uniformQuantity((long)(1000L * context.getOrThrow(MIMaterialProperties.TANK_CAPACITY)));
        EntityBlock factory = (pos, state) -> new TankBlockEntity((BlockEntityType)bet.get(), pos, state);
        BlockWithItemHolder<Block, BlockItem> blockHolder = new BlockWithItemHolder<Block, BlockItem>(context.id(), context.englishName(), context.registry().blockRegistry(), p -> new TankBlock(factory, storageBehaviour), context.registry().itemRegistry(), (b, p) -> new TankItem((TankBlock)b, p));
        RegisteredMaterialPart registered = RegisteredMaterialPart.existingBlock(blockHolder);
        context.register(blockHolder);
        context.registry().blockEntityRegistry().register(context.id().getPath(), () -> {
            bet.set(BlockEntityType.Builder.of((arg_0, arg_1) -> ((EntityBlock)factory).newBlockEntity(arg_0, arg_1), (Block[])new Block[]{blockHolder.get()}).build(null));
            return (BlockEntityType)bet.get();
        });
        CapabilitiesListeners.register(context.registry().modId(), event -> {
            event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)bet.get(), (be, side) -> new SlotFluidHandler((SingleSlotStorage)be));
            TankItem item = (TankItem)blockHolder.asItem();
            event.registerItem(Capabilities.FluidHandler.ITEM, (stack, __) -> new ContainerItem.FluidHandler(stack, (ContainerItem)item), new ItemLike[]{item});
        });
        MICommonProxy.INSTANCE.registerPartTankClient(bet::get, context.get(MaterialProperties.MEAN_RGB).intValue());
        return registered;
    });
    public static final MaterialPart TINY_DUST = ((MaterialPart)MIMaterialParts.create("tiny_dust", "Tiny Dust").set((MaterialProperty)MaterialProperties.ITEM_REFERENCE, MaterialPartItemReferenceFormatter.tag())).itemModelBuilder(CommonModelBuilders::generated).item(CommonMaterialPartRegisters.itemTagCommon("tiny_dusts"));
    public static final MaterialPart WIRE = MIMaterialParts.create("wire", "Wire").itemModelBuilder(CommonModelBuilders::generated);
    public static final MaterialPart WIRE_MAGNETIC = MIMaterialParts.create("wire_magnetic", "Magnetic Wire").formatting((arg_0, arg_1) -> MIMaterialParts.lambda$static$36("%s_%s", arg_0, arg_1), (m, p) -> "Magnetic %s Wire".formatted(m)).itemModelBuilder(CommonModelBuilders::generated);
    public static final MaterialPart FUEL_ROD_DEPLETED = MIMaterialParts.create("fuel_rod_depleted", "Depleted Fuel Rod").formattingMaterialOnly(arg_0 -> MIMaterialParts.lambda$static$39("%s_fuel_rod_depleted", arg_0), arg_0 -> MIMaterialParts.lambda$static$40("Depleted %s Fuel Rod", arg_0));
    public static final MaterialPart FUEL_ROD = ((MaterialPart)MIMaterialParts.create("fuel_rod", "Fuel Rod").set((MaterialProperty)MIMaterialProperties.NUCLEAR_FUEL_SIZE, (Object)1)).itemFactory(MIMaterialParts.fuelRodFactory());
    public static final MaterialPart FUEL_ROD_DOUBLE = ((MaterialPart)MIMaterialParts.create("fuel_rod_double", "Double Fuel Rod").set((MaterialProperty)MIMaterialProperties.NUCLEAR_FUEL_SIZE, (Object)2)).itemFactory(MIMaterialParts.fuelRodFactory());
    public static final MaterialPart FUEL_ROD_QUAD = ((MaterialPart)MIMaterialParts.create("fuel_rod_quad", "Quad Fuel Rod").set((MaterialProperty)MIMaterialProperties.NUCLEAR_FUEL_SIZE, (Object)4)).itemFactory(MIMaterialParts.fuelRodFactory());
    public static final MaterialPart[] ALL_FUEL_RODS = new MaterialPart[]{FUEL_ROD, FUEL_ROD_DOUBLE, FUEL_ROD_QUAD, FUEL_ROD_DEPLETED};
    public static final MaterialPart N_DOPED_PLATE = MIMaterialParts.create("n_doped_plate", "N-Doped Plate").formatting((arg_0, arg_1) -> MIMaterialParts.lambda$static$41("%s_%s", arg_0, arg_1), (m, p) -> "N-Doped %s Plate".formatted(m)).itemModelBuilder(CommonModelBuilders::generated);
    public static final MaterialPart P_DOPED_PLATE = MIMaterialParts.create("p_doped_plate", "P-Doped Plate").formatting((arg_0, arg_1) -> MIMaterialParts.lambda$static$43("%s_%s", arg_0, arg_1), (m, p) -> "P-Doped %s Plate".formatted(m)).itemModelBuilder(CommonModelBuilders::generated);
    public static final MaterialPart[] ITEM_PURE_NON_METAL = new MaterialPart[]{CRUSHED_DUST, MaterialParts.DUST, TINY_DUST};
    public static final MaterialPart[] ITEM_PURE_METAL = new MaterialPart[]{MaterialParts.INGOT, MaterialParts.NUGGET, MaterialParts.DUST, TINY_DUST};

    public static MaterialPartItemFactory fuelRodFactory() {
        return (c, p) -> {
            int size = c.getOrThrow(MIMaterialProperties.NUCLEAR_FUEL_SIZE);
            IsotopeFuel fuel = c.getOrThrow(MIMaterialProperties.ISOTOPE);
            NuclearFuel.NuclearFuelParams fuelParams = new NuclearFuel.NuclearFuelParams(10240000 * size, fuel.maxTemp, fuel.tempLimitLow, fuel.tempLimitHigh, fuel.neutronsMultiplication, fuel.directEnergyFactor, size);
            NeutronBehaviour neutronBehaviour = NeutronBehaviour.of((NuclearConstant.ScatteringType)NuclearConstant.ScatteringType.HEAVY, (IsotopeParams)fuel, (double)size);
            return new NuclearFuel(p.stacksTo(1), fuelParams, neutronBehaviour, c.registry().id("%s_fuel_rod_depleted".formatted(c.material().id().getPath())));
        };
    }

    public static MaterialPart create(String id, String englishName) {
        return new MaterialPart(MI.id((String)id), englishName);
    }

    private static /* synthetic */ String lambda$static$43(String rec$, Object xva$0, Object xva$1) {
        return "%s_%s".formatted(xva$0, xva$1);
    }

    private static /* synthetic */ String lambda$static$41(String rec$, Object xva$0, Object xva$1) {
        return "%s_%s".formatted(xva$0, xva$1);
    }

    private static /* synthetic */ String lambda$static$40(String rec$, Object xva$0) {
        return "Depleted %s Fuel Rod".formatted(xva$0);
    }

    private static /* synthetic */ String lambda$static$39(String rec$, Object xva$0) {
        return "%s_fuel_rod_depleted".formatted(xva$0);
    }

    private static /* synthetic */ String lambda$static$36(String rec$, Object xva$0, Object xva$1) {
        return "%s_%s".formatted(xva$0, xva$1);
    }

    private static /* synthetic */ String lambda$static$24(String rec$, Object xva$0, Object xva$1) {
        return "%s_%s".formatted(xva$0, xva$1);
    }

    private static /* synthetic */ String lambda$static$23(String rec$, Object xva$0) {
        return "Plasma Handling %s Machine Casing".formatted(xva$0);
    }

    private static /* synthetic */ String lambda$static$22(String rec$, Object xva$0) {
        return "plasma_handling_%s_machine_casing".formatted(xva$0);
    }

    private static /* synthetic */ String lambda$static$21(String rec$, Object xva$0) {
        return "Solid %s Machine Casing".formatted(xva$0);
    }

    private static /* synthetic */ String lambda$static$20(String rec$, Object xva$0) {
        return "solid_%s_machine_casing".formatted(xva$0);
    }

    private static /* synthetic */ String lambda$static$19(String rec$, Object xva$0) {
        return "Clean %s Machine Casing".formatted(xva$0);
    }

    private static /* synthetic */ String lambda$static$18(String rec$, Object xva$0) {
        return "clean_%s_machine_casing".formatted(xva$0);
    }

    private static /* synthetic */ String lambda$static$17(String rec$, Object xva$0) {
        return "%s Plated Bricks".formatted(xva$0);
    }

    private static /* synthetic */ String lambda$static$16(String rec$, Object xva$0) {
        return "%s_plated_bricks".formatted(xva$0);
    }

    private static /* synthetic */ Block lambda$static$5(EntityBlock factory, StorageBehaviour storageBehaviour, BlockBehaviour.Properties p) {
        return new BarrelBlock(factory, storageBehaviour);
    }
}

