/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.client.layer;

import com.blakebr0.cucumber.iface.IColored;
import com.blakebr0.ironjetpacks.IronJetpacks;
import com.blakebr0.ironjetpacks.compat.curios.CuriosCompat;
import com.blakebr0.ironjetpacks.item.JetpackItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;

public class JetpackRenderLayer<T extends LivingEntity, M extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    private static final ResourceLocation TEXTURE = IronJetpacks.resource("textures/models/armor/jetpack_layer_1.png");
    private static final ResourceLocation TEXTURE_OVERLAY = IronJetpacks.resource("textures/models/armor/jetpack_layer_1_overlay.png");

    public JetpackRenderLayer(RenderLayerParent<T, M> parent) {
        super(parent);
    }

    public void render(PoseStack matrix, MultiBufferSource buffer, int lightness, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack stack = entity.getItemBySlot(EquipmentSlot.CHEST);
        if (stack.getItem() instanceof JetpackItem) {
            return;
        }
        CuriosCompat.findJetpackCurio(entity, slot -> slot.slotContext().visible()).ifPresent(curio -> {
            HumanoidModel model = IClientItemExtensions.of((ItemStack)curio).getHumanoidArmorModel(entity, curio, EquipmentSlot.CHEST, null);
            ((HumanoidModel)this.getParentModel()).copyPropertiesTo(model);
            Item patt0$temp = curio.getItem();
            if (patt0$temp instanceof IColored) {
                IColored colored = (IColored)patt0$temp;
                int color = colored.getColor(1, curio);
                int r = color >> 16 & 0xFF;
                int g = color >> 8 & 0xFF;
                int b = color & 0xFF;
                this.renderModel(matrix, buffer, lightness, curio.hasFoil(), (Model)model, r, g, b, TEXTURE);
                this.renderModel(matrix, buffer, lightness, curio.hasFoil(), (Model)model, 255, 255, 255, TEXTURE_OVERLAY);
            } else {
                this.renderModel(matrix, buffer, lightness, curio.hasFoil(), (Model)model, 255, 255, 255, TEXTURE);
            }
        });
    }

    private void renderModel(PoseStack matrix, MultiBufferSource buffer, int lightness, boolean foil, Model model, int r, int g, int b, ResourceLocation armorResource) {
        VertexConsumer vertex = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)buffer, (RenderType)RenderType.armorCutoutNoCull((ResourceLocation)armorResource), (boolean)foil);
        model.renderToBuffer(matrix, vertex, lightness, OverlayTexture.NO_OVERLAY, FastColor.ARGB32.color((int)255, (int)r, (int)g, (int)b));
    }
}

