/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.crafting.recipe;

import com.blakebr0.ironjetpacks.init.ModDataComponentTypes;
import com.blakebr0.ironjetpacks.init.ModItems;
import com.blakebr0.ironjetpacks.init.ModRecipeSerializers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;

public class JetpackUpgradeRecipe
extends ShapedRecipe {
    private final ItemStack result;

    public JetpackUpgradeRecipe(String group, ShapedRecipePattern pattern, ItemStack result, boolean showNotification) {
        super(group, CraftingBookCategory.EQUIPMENT, pattern, result, showNotification);
        this.result = result;
    }

    public ItemStack assemble(CraftingInput inventory, HolderLookup.Provider access) {
        ItemStack stack = inventory.getItem(4);
        ItemStack result = this.result.copy();
        if (!stack.isEmpty() && stack.is(ModItems.JETPACK)) {
            result.applyComponents(stack.getComponents());
            result.set(ModDataComponentTypes.JETPACK_ID, (Object)((ResourceLocation)this.result.get(ModDataComponentTypes.JETPACK_ID)));
        }
        return result;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.CRAFTING_JETPACK_UPGRADE.get();
    }

    public static class Serializer
    implements RecipeSerializer<JetpackUpgradeRecipe> {
        public static final MapCodec<JetpackUpgradeRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(ShapedRecipe::getGroup), (App)ShapedRecipePattern.MAP_CODEC.forGetter(recipe -> recipe.pattern), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.BOOL.optionalFieldOf("show_notification", (Object)Boolean.TRUE).forGetter(ShapedRecipe::showNotification)).apply((Applicative)builder, JetpackUpgradeRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, JetpackUpgradeRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<JetpackUpgradeRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, JetpackUpgradeRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static JetpackUpgradeRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            String group = buffer.readUtf();
            ShapedRecipePattern pattern = (ShapedRecipePattern)ShapedRecipePattern.STREAM_CODEC.decode((Object)buffer);
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            boolean showNotification = buffer.readBoolean();
            return new JetpackUpgradeRecipe(group, pattern, result, showNotification);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, JetpackUpgradeRecipe recipe) {
            buffer.writeUtf(recipe.getGroup());
            ShapedRecipePattern.STREAM_CODEC.encode((Object)buffer, (Object)recipe.pattern);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
            buffer.writeBoolean(recipe.showNotification());
        }
    }
}

