/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui;

import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiChemicalGauge;
import mekanism.client.gui.element.gauge.GuiEnergyGauge;
import mekanism.client.gui.element.gauge.GuiFluidGauge;
import mekanism.client.gui.element.gauge.GuiNumberGauge;
import mekanism.client.gui.element.progress.GuiProgress;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.inventory.container.tile.EmptyTileContainer;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.generators.client.gui.GuiFusionReactorInfo;
import mekanism.generators.client.gui.element.GuiFusionReactorTab;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.content.fusion.FusionReactorMultiblockData;
import mekanism.generators.common.tile.fusion.TileEntityFusionReactorController;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class GuiFusionReactorHeat
extends GuiFusionReactorInfo {
    private static final double MAX_LEVEL = 5.0E8;

    public GuiFusionReactorHeat(EmptyTileContainer<TileEntityFusionReactorController> container, Inventory inv, Component title) {
        super(container, inv, title);
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.addRenderableWidget((GuiElement)new GuiNumberGauge(new GuiNumberGauge.INumberInfoHandler(){

            public TextureAtlasSprite getIcon() {
                return MekanismRenderer.getBaseFluidTexture((Fluid)Fluids.LAVA, (MekanismRenderer.FluidTextureType)MekanismRenderer.FluidTextureType.STILL);
            }

            public double getLevel() {
                return ((FusionReactorMultiblockData)((TileEntityFusionReactorController)GuiFusionReactorHeat.this.tile).getMultiblock()).getLastPlasmaTemp();
            }

            public double getScaledLevel() {
                return Math.min(1.0, this.getLevel() / 5.0E8);
            }

            public Component getText() {
                return GeneratorsLang.REACTOR_PLASMA.translate(new Object[]{MekanismUtils.getTemperatureDisplay((double)this.getLevel(), (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true)});
            }
        }, GaugeType.STANDARD, (IGuiWrapper)this, 12, 50));
        this.addRenderableWidget((GuiElement)new GuiProgress(() -> {
            FusionReactorMultiblockData multiblock = (FusionReactorMultiblockData)((TileEntityFusionReactorController)this.tile).getMultiblock();
            return multiblock.getLastPlasmaTemp() > multiblock.getLastCaseTemp();
        }, ProgressType.SMALL_RIGHT, (IGuiWrapper)this, 34, 76));
        this.addRenderableWidget((GuiElement)new GuiNumberGauge(new GuiNumberGauge.INumberInfoHandler(){

            public TextureAtlasSprite getIcon() {
                return MekanismRenderer.getBaseFluidTexture((Fluid)Fluids.LAVA, (MekanismRenderer.FluidTextureType)MekanismRenderer.FluidTextureType.STILL);
            }

            public double getLevel() {
                return ((FusionReactorMultiblockData)((TileEntityFusionReactorController)GuiFusionReactorHeat.this.tile).getMultiblock()).getLastCaseTemp();
            }

            public double getScaledLevel() {
                return Math.min(1.0, this.getLevel() / 5.0E8);
            }

            public Component getText() {
                return GeneratorsLang.REACTOR_CASE.translate(new Object[]{MekanismUtils.getTemperatureDisplay((double)this.getLevel(), (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true)});
            }
        }, GaugeType.STANDARD, (IGuiWrapper)this, 66, 50));
        this.addRenderableWidget((GuiElement)new GuiProgress(() -> ((FusionReactorMultiblockData)((TileEntityFusionReactorController)this.tile).getMultiblock()).getCaseTemp() > 0.0, ProgressType.SMALL_RIGHT, (IGuiWrapper)this, 88, 61));
        this.addRenderableWidget((GuiElement)new GuiProgress(() -> {
            FusionReactorMultiblockData multiblock = (FusionReactorMultiblockData)((TileEntityFusionReactorController)this.tile).getMultiblock();
            return multiblock.getCaseTemp() > 0.0 && !multiblock.waterTank.isEmpty() && multiblock.steamTank.getStored() < multiblock.steamTank.getCapacity();
        }, ProgressType.SMALL_RIGHT, (IGuiWrapper)this, 88, 91));
        this.addRenderableWidget((GuiElement)new GuiFluidGauge(() -> ((FusionReactorMultiblockData)((TileEntityFusionReactorController)this.tile).getMultiblock()).waterTank, () -> ((TileEntityFusionReactorController)this.tile).getFluidTanks(null), GaugeType.SMALL, (IGuiWrapper)this, 120, 84));
        this.addRenderableWidget((GuiElement)new GuiChemicalGauge(() -> ((FusionReactorMultiblockData)((TileEntityFusionReactorController)this.tile).getMultiblock()).steamTank, () -> ((TileEntityFusionReactorController)this.tile).getChemicalTanks(null), GaugeType.SMALL, (IGuiWrapper)this, 156, 84));
        this.addRenderableWidget((GuiElement)new GuiEnergyGauge(((FusionReactorMultiblockData)((TileEntityFusionReactorController)this.tile).getMultiblock()).energyContainer, GaugeType.SMALL, (IGuiWrapper)this, 120, 46));
        this.addRenderableWidget((GuiElement)new GuiFusionReactorTab((IGuiWrapper)this, (TileEntityFusionReactorController)this.tile, GuiFusionReactorTab.FusionReactorTab.FUEL));
        this.addRenderableWidget((GuiElement)new GuiFusionReactorTab((IGuiWrapper)this, (TileEntityFusionReactorController)this.tile, GuiFusionReactorTab.FusionReactorTab.STAT));
    }
}

