/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.content.gear.mekasuit;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Map;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.annotations.ParametersAreNotNullByDefault;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.functions.ConstantPredicates;
import mekanism.api.functions.FloatSupplier;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.gear.IModuleContainer;
import mekanism.api.math.MathUtils;
import mekanism.common.config.listener.ConfigBasedCachedFloatSupplier;
import mekanism.common.config.value.CachedFloatValue;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

@ParametersAreNotNullByDefault
public class ModuleGeothermalGeneratorUnit
implements ICustomModule<ModuleGeothermalGeneratorUnit> {
    private static final Int2ObjectMap<ICustomModule.ModuleDamageAbsorbInfo> DAMAGE_ABSORB_VALUES = (Int2ObjectMap)Util.make(() -> {
        int maxSize = 8;
        Int2ObjectArrayMap map = new Int2ObjectArrayMap(maxSize);
        for (int count = 1; count <= maxSize; ++count) {
            float ratio = (float)count / (float)maxSize;
            map.put(count, (Object)new ICustomModule.ModuleDamageAbsorbInfo((FloatSupplier)new ConfigBasedCachedFloatSupplier(() -> MekanismGeneratorsConfig.gear.mekaSuitHeatDamageReductionRatio.get() * ratio, new CachedFloatValue[]{MekanismGeneratorsConfig.gear.mekaSuitHeatDamageReductionRatio}), ConstantPredicates.ZERO_LONG));
        }
        return map;
    });

    public void tickServer(IModule<ModuleGeothermalGeneratorUnit> module, IModuleContainer moduleContainer, ItemStack stack, Player player) {
        IEnergyContainer energyContainer = module.getEnergyContainer(stack);
        if (energyContainer != null && energyContainer.getNeeded() > 0L) {
            double highestScaledDegrees = 0.0;
            double legHeight = player.isCrouching() ? 0.6 : 0.7;
            Map fluidsIn = MekanismUtils.getFluidsIn((Player)player, (double)legHeight, (bb, data) -> new AABB(bb.minX, bb.minY, bb.minZ, bb.maxX, Math.min(bb.minY + data, bb.maxY), bb.maxZ));
            for (Map.Entry entry : fluidsIn.entrySet()) {
                double scaledDegrees;
                MekanismUtils.FluidInDetails details = (MekanismUtils.FluidInDetails)entry.getValue();
                double height = details.getMaxHeight();
                if (height < 0.25) continue;
                double temperature = 0.0;
                Map positions = details.getPositions();
                for (Map.Entry positionEntry : positions.entrySet()) {
                    temperature += (double)((FluidType)entry.getKey()).getTemperature((FluidState)positionEntry.getValue(), (BlockAndTintGetter)player.level(), (BlockPos)positionEntry.getKey());
                }
                if (!((temperature /= (double)positions.size()) > 300.0) || !((scaledDegrees = (temperature - 300.0) * height / legHeight) > highestScaledDegrees)) continue;
                highestScaledDegrees = scaledDegrees;
            }
            if (highestScaledDegrees > 0.0 || player.isOnFire()) {
                if (highestScaledDegrees < 200.0 && player.isOnFire()) {
                    highestScaledDegrees = 200.0;
                }
                long rate = MathUtils.clampToLong((double)((double)((long)module.getInstalledCount() * MekanismGeneratorsConfig.gear.mekaSuitGeothermalChargingRate.get()) * highestScaledDegrees));
                energyContainer.insert(rate, Action.EXECUTE, AutomationType.MANUAL);
            }
        }
    }

    @Nullable
    public ICustomModule.ModuleDamageAbsorbInfo getDamageAbsorbInfo(IModule<ModuleGeothermalGeneratorUnit> module, DamageSource damageSource) {
        return damageSource.is(DamageTypeTags.IS_FIRE) ? (ICustomModule.ModuleDamageAbsorbInfo)DAMAGE_ABSORB_VALUES.get(module.getInstalledCount()) : null;
    }
}

