/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.blocks;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vswe.stevescarts.api.upgrades.BaseUpgradeEffect;
import vswe.stevescarts.blocks.BlockContainerBase;
import vswe.stevescarts.blocks.tileentities.TileEntityCartAssembler;
import vswe.stevescarts.blocks.tileentities.TileEntityUpgrade;
import vswe.stevescarts.upgrades.AssemblerUpgrade;

public class BlockUpgrade
extends BlockContainerBase {
    public static final MapCodec<BlockUpgrade> CODEC = BlockUpgrade.simpleCodec(BlockUpgrade::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty CONNECTED = BooleanProperty.create((String)"connected");
    private static final VoxelShape[] BBS = new VoxelShape[6];
    private final AssemblerUpgrade assemblerUpgrade;

    public BlockUpgrade(BlockBehaviour.Properties properties) {
        this(properties, null);
    }

    public BlockUpgrade(BlockBehaviour.Properties properties, AssemblerUpgrade assemblerUpgrade) {
        super(properties);
        this.assemblerUpgrade = assemblerUpgrade;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)CONNECTED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, CONNECTED});
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter blockReader, @NotNull BlockPos blockPos, @NotNull CollisionContext selectionContext) {
        return BBS[((Direction)state.getValue((Property)FACING)).getOpposite().ordinal()];
    }

    @javax.annotation.Nullable
    public BlockState getStateForPlacement(BlockPlaceContext blockItemUseContext) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)blockItemUseContext.getHorizontalDirection())).setValue((Property)CONNECTED, (Comparable)Boolean.valueOf(false));
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new TileEntityUpgrade(this.assemblerUpgrade, blockPos, blockState);
    }

    public boolean canSurvive(@NotNull BlockState blockState, LevelReader iWorldReader, BlockPos blockPos) {
        BlockPos offset = blockPos.relative(this.getFacing(blockState));
        return iWorldReader.getBlockEntity(offset) != null && iWorldReader.getBlockEntity(offset) instanceof TileEntityCartAssembler;
    }

    public Direction getFacing(BlockState blockState) {
        return (Direction)blockState.getValue((Property)FACING);
    }

    public void randomTick(@NotNull BlockState blockState, @NotNull ServerLevel serverWorld, @NotNull BlockPos blockPos, @NotNull RandomSource p_225542_4_) {
        if (!this.canSurvive(blockState, (LevelReader)serverWorld, blockPos) && serverWorld.removeBlock(blockPos, true)) {
            ItemEntity item = new ItemEntity((Level)serverWorld, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), new ItemStack((ItemLike)this));
            serverWorld.addFreshEntity((Entity)item);
        }
        super.randomTick(blockState, serverWorld, blockPos, p_225542_4_);
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState blockState, Level world, @NotNull BlockPos blockPos, @NotNull Player playerEntity, BlockHitResult result) {
        if (!world.isClientSide && !playerEntity.isCrouching()) {
            playerEntity.openMenu((MenuProvider)world.getBlockEntity(blockPos), blockPos);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public void appendHoverText(@NotNull ItemStack itemStack, @javax.annotation.Nullable Item.TooltipContext iBlockReader, @NotNull List<Component> tooltip, @NotNull TooltipFlag iTooltipFlag) {
        if (this.assemblerUpgrade != null) {
            for (BaseUpgradeEffect effect : this.assemblerUpgrade.getEffects()) {
                tooltip.add((Component)Component.translatable((String)effect.getName()));
            }
        }
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    static {
        float thickness = 2.0f;
        BlockUpgrade.BBS[Direction.UP.ordinal()] = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)thickness, (double)16.0);
        BlockUpgrade.BBS[Direction.DOWN.ordinal()] = Block.box((double)0.0, (double)(16.0f - thickness), (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        BlockUpgrade.BBS[Direction.EAST.ordinal()] = Block.box((double)0.0, (double)0.0, (double)0.0, (double)thickness, (double)16.0, (double)16.0);
        BlockUpgrade.BBS[Direction.WEST.ordinal()] = Block.box((double)(16.0f - thickness), (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        BlockUpgrade.BBS[Direction.NORTH.ordinal()] = Block.box((double)0.0, (double)0.0, (double)(16.0f - thickness), (double)16.0, (double)16.0, (double)16.0);
        BlockUpgrade.BBS[Direction.SOUTH.ordinal()] = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)thickness);
    }
}

