/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.datagen;

import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import vswe.stevescarts.api.modules.data.ModuleData;
import vswe.stevescarts.helpers.ComponentTypes;
import vswe.stevescarts.init.ModBlocks;
import vswe.stevescarts.init.ModItems;
import vswe.stevescarts.init.StevesCartsModules;

public class GeneratorRecipes
extends RecipeProvider {
    public GeneratorRecipes(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(output, lookupProvider);
    }

    protected void buildRecipes(RecipeOutput consumer) {
        this.addBlockRecipes(consumer);
        this.addSmithingTableRecipes(consumer);
        this.addModuleRecipes(consumer);
    }

    private void addBlockRecipes(RecipeOutput consumer) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.ADVANCED_DETECTOR.get())).pattern("#P#").pattern("#X#").pattern("#P#").define(Character.valueOf('X'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('#'), Tags.Items.INGOTS_IRON).define(Character.valueOf('P'), (ItemLike)Items.STONE_PRESSURE_PLATE).group("stevescarts").unlockedBy("has_item", GeneratorRecipes.has((TagKey)Tags.Items.INGOTS_IRON)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.GALGADORIAN_METAL.get())).pattern("XXX").pattern("XXX").pattern("XXX").define(Character.valueOf('X'), (ItemLike)ModItems.COMPONENTS.get((Object)ComponentTypes.GALGADORIAN_METAL).get()).group("stevescarts").unlockedBy("has_item", GeneratorRecipes.has((TagKey)Tags.Items.INGOTS_IRON)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.REINFORCED_METAL.get())).pattern("XXX").pattern("XXX").pattern("XXX").define(Character.valueOf('X'), (ItemLike)ModItems.COMPONENTS.get((Object)ComponentTypes.REINFORCED_METAL).get()).group("stevescarts").unlockedBy("has_item", GeneratorRecipes.has((TagKey)Tags.Items.INGOTS_IRON)).save(consumer);
    }

    private void addModuleRecipes(RecipeOutput consumer) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)this.getStackFromModule(StevesCartsModules.CHUNK_LOADER).getItem()).pattern("III").pattern("GEG").pattern("IDI").define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('E'), (ItemLike)Items.ENDER_EYE).define(Character.valueOf('D'), Tags.Items.GEMS_DIAMOND).group("stevescarts").unlockedBy("has_item", GeneratorRecipes.has((TagKey)Tags.Items.INGOTS_IRON)).save(consumer);
    }

    private void addSmithingTableRecipes(RecipeOutput consumer) {
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE)}), (Ingredient)Ingredient.of((ItemStack[])new ItemStack[]{this.getStackFromModule(StevesCartsModules.BASIC_WOOD_CUTTER)}), (Ingredient)Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.NETHERITE_INGOT)}), (RecipeCategory)RecipeCategory.MISC, (Item)this.getStackFromModule(StevesCartsModules.NETHERITE_WOOD_CUTTER).getItem()).unlocks("has_item", GeneratorRecipes.has((TagKey)Tags.Items.INGOTS_NETHERITE)).save(consumer, "netherite_wood_cutter");
    }

    private ItemStack getStackFromModule(ModuleData moduleData) {
        if (moduleData == null) {
            return ItemStack.EMPTY;
        }
        Supplier<Item> itemSupplier = ModItems.MODULES.get(moduleData);
        if (itemSupplier == null || itemSupplier.get() == null) {
            return ItemStack.EMPTY;
        }
        return new ItemStack((ItemLike)itemSupplier.get());
    }
}

