/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.helpers;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.Enchantment;
import org.jetbrains.annotations.Nullable;
import vswe.stevescarts.helpers.ModularEnchantments;

public class EnchantmentData {
    @Nullable
    private Holder<Enchantment> enchant;
    private int value;
    private boolean dirty = false;

    public EnchantmentData(Holder<Enchantment> enchant) {
        this.enchant = enchant;
        this.value = 0;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int val) {
        this.value = val;
        this.dirty = true;
    }

    public void setEnchantment(Holder<Enchantment> enchant) {
        this.enchant = enchant;
        this.dirty = true;
    }

    @Nullable
    public Enchantment getEnchant() {
        return this.enchant == null ? null : (Enchantment)this.enchant.value();
    }

    public Holder<Enchantment> getEnchantHolder() {
        return this.enchant;
    }

    public void damageEnchant(int dmg) {
        this.damageEnchantLevel(dmg, this.getValue(), 1);
        if (this.getValue() <= 0) {
            this.setEnchantment(null);
        }
    }

    private boolean damageEnchantLevel(int dmg, int value, int level) {
        if (this.enchant == null) {
            return false;
        }
        if (level > ((Enchantment)this.enchant.value()).getMaxLevel() || value <= 0) {
            return false;
        }
        Optional optkey = this.enchant.unwrapKey();
        if (!optkey.isPresent()) {
            return false;
        }
        int levelvalue = ModularEnchantments.getValue((ResourceKey<Enchantment>)((ResourceKey)optkey.get()), level);
        if (!this.damageEnchantLevel(dmg, value - levelvalue, level + 1)) {
            int dmgdealt = dmg * (int)Math.pow(2.0, level - 1);
            if (dmgdealt > value) {
                dmgdealt = value;
            }
            this.setValue(this.getValue() - dmgdealt);
        }
        return true;
    }

    public int getLevel() {
        if (this.enchant == null) {
            return 0;
        }
        Optional optkey = this.enchant.unwrapKey();
        if (!optkey.isPresent()) {
            return 0;
        }
        int value = this.getValue();
        for (int i = 0; i < ((Enchantment)this.enchant.value()).getMaxLevel(); ++i) {
            if (value <= 0) {
                return i;
            }
            value -= ModularEnchantments.getValue((ResourceKey<Enchantment>)((ResourceKey)optkey.get()), i + 1);
        }
        return ((Enchantment)this.enchant.value()).getMaxLevel();
    }

    public String getInfoText() {
        if (this.enchant == null) {
            return "";
        }
        Optional optkey = this.enchant.unwrapKey();
        if (!optkey.isPresent()) {
            return "";
        }
        int value = this.getValue();
        int level = 0;
        int percentage = 0;
        for (level = 1; level <= ((Enchantment)this.enchant.value()).getMaxLevel(); ++level) {
            if (value <= 0) continue;
            int levelvalue = ModularEnchantments.getValue((ResourceKey<Enchantment>)((ResourceKey)optkey.get()), level);
            percentage = 100 * value / levelvalue;
            if ((value -= levelvalue) < 0) break;
        }
        return String.valueOf(ChatFormatting.YELLOW) + Enchantment.getFullname(this.enchant, (int)this.getLevel()).getString() + "\n" + percentage + "% left of this tier";
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeVarInt(this.enchant == null ? -1 : this.value);
        if (this.enchant != null) {
            buf.writeResourceLocation(Objects.requireNonNull(ResourceLocation.parse((String)this.enchant.getRegisteredName())));
        }
    }

    public static EnchantmentData read(RegistryFriendlyByteBuf buf) {
        int value = buf.readVarInt();
        if (value == -1) {
            return new EnchantmentData(null);
        }
        ResourceKey resKey = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)buf.readResourceLocation());
        Holder.Reference enchantment = buf.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(resKey);
        EnchantmentData data = new EnchantmentData((Holder<Enchantment>)enchantment);
        data.setValue(value);
        return data;
    }

    public CompoundTag save(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        if (this.enchant == null) {
            return tag;
        }
        tag.putString("key", this.enchant.getRegisteredName());
        tag.putInt("value", this.getLevel());
        return tag;
    }

    @Nullable
    public static EnchantmentData load(CompoundTag tag, HolderLookup.Provider provider) {
        if (!tag.contains("key")) {
            return null;
        }
        ResourceLocation key = ResourceLocation.parse((String)tag.getString("key"));
        ResourceKey resKey = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)key);
        Holder.Reference enchant = provider.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(resKey);
        EnchantmentData data = new EnchantmentData((Holder<Enchantment>)enchant);
        data.setValue(tag.getInt("value"));
        return data;
    }

    public boolean isDirty() {
        if (this.dirty) {
            this.dirty = false;
            return true;
        }
        return false;
    }
}

