/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.init;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Consumer;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public class ModItemData {
    public static final DeferredRegister<DataComponentType<?>> DATA = DeferredRegister.create((String)"stevescarts", (ResourceKey)Registries.DATA_COMPONENT_TYPE);
    public static final RegistrySupplier<DataComponentType<CustomData>> ITEM_TAG = DATA.register("item_tag", () -> DataComponentType.builder().persistent(CustomData.CODEC).networkSynchronized(CustomData.STREAM_CODEC).build());

    public static void init() {
        DATA.register();
    }

    public static boolean hasTag(ItemStack stack) {
        return stack.has(ITEM_TAG);
    }

    public static CompoundTag getTagCopy(ItemStack stack) {
        return ((CustomData)stack.getOrDefault(ITEM_TAG, (Object)CustomData.of((CompoundTag)new CompoundTag()))).copyTag();
    }

    public static void setTag(ItemStack stack, CompoundTag tag) {
        CustomData.set((DataComponentType)((DataComponentType)ITEM_TAG.get()), (ItemStack)stack, (CompoundTag)tag);
    }

    public static void removeTag(ItemStack stack) {
        stack.remove(ITEM_TAG);
    }

    public static void modifyTag(ItemStack stack, Consumer<CompoundTag> modifyCallback) {
        CompoundTag tag = ModItemData.getTagCopy(stack);
        modifyCallback.accept(tag);
        ModItemData.setTag(stack, tag);
    }
}

