/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.utilityvest;

import com.mojang.logging.LogUtils;
import dev.satherov.utilityvest.client.input.UVKeybindManager;
import dev.satherov.utilityvest.client.screen.UVFilterScreen;
import dev.satherov.utilityvest.client.screen.UVInventoryScreen;
import dev.satherov.utilityvest.common.capabilities.UVVestCapability;
import dev.satherov.utilityvest.common.item.UVVestItem;
import dev.satherov.utilityvest.core.UVRegistry;
import dev.satherov.utilityvest.network.UVNetworking;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.slf4j.Logger;
import top.theillusivec4.curios.api.CuriosCapability;

@Mod(value="utilityvest")
public class UtilityVest {
    public static final String MOD_ID = "utilityvest";
    private static final Logger LOGGER = LogUtils.getLogger();

    public UtilityVest(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(UVNetworking::registerPayload);
        UVRegistry.ITEMS.register(modEventBus);
        UVRegistry.DATA_COMPONENT_TYPES.register(modEventBus);
        UVRegistry.RECIPE_SERIALIZERS.register(modEventBus);
        UVRegistry.CREATIVE_MODE_TABS.register(modEventBus);
        UVRegistry.MENU_TYPES.register(modEventBus);
        modEventBus.addListener(this::registerCapabilities);
        if (FMLEnvironment.dist.isClient()) {
            modEventBus.addListener(Client::ClientSetup);
            modEventBus.addListener(Client::registerMenuScreens);
            modEventBus.addListener(Client::registerKeys);
        }
    }

    public static ResourceLocation rl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public void registerCapabilities(RegisterCapabilitiesEvent event) {
        UVRegistry.ITEMS.getEntries().stream().toList().forEach(item -> {
            Object patt0$temp = item.get();
            if (patt0$temp instanceof UVVestItem) {
                UVVestItem vest = (UVVestItem)((Object)((Object)patt0$temp));
                event.registerItem(CuriosCapability.ITEM, (stack, ctx) -> () -> stack, new ItemLike[]{vest});
                event.registerItem(Capabilities.ItemHandler.ITEM, (stack, context) -> new UVVestCapability((ItemStack)stack, vest), new ItemLike[]{vest});
            }
        });
    }

    static class Client {
        Client() {
        }

        public static void ClientSetup(FMLClientSetupEvent event) {
            NeoForge.EVENT_BUS.register((Object)new UVKeybindManager());
        }

        public static void registerMenuScreens(RegisterMenuScreensEvent event) {
            event.register((MenuType)UVRegistry.INVENTORY_MENU_ONE.get(), UVInventoryScreen::new);
            event.register((MenuType)UVRegistry.INVENTORY_MENU_TWO.get(), UVInventoryScreen::new);
            event.register((MenuType)UVRegistry.INVENTORY_MENU_THREE.get(), UVInventoryScreen::new);
            event.register((MenuType)UVRegistry.INVENTORY_MENU_FOUR.get(), UVInventoryScreen::new);
            event.register((MenuType)UVRegistry.INVENTORY_MENU_FIVE.get(), UVInventoryScreen::new);
            event.register((MenuType)UVRegistry.FILTER_MENU_ONE.get(), UVFilterScreen::new);
            event.register((MenuType)UVRegistry.FILTER_MENU_TWO.get(), UVFilterScreen::new);
            event.register((MenuType)UVRegistry.FILTER_MENU_THREE.get(), UVFilterScreen::new);
            event.register((MenuType)UVRegistry.FILTER_MENU_FOUR.get(), UVFilterScreen::new);
            event.register((MenuType)UVRegistry.FILTER_MENU_FIVE.get(), UVFilterScreen::new);
        }

        public static void registerKeys(RegisterKeyMappingsEvent event) {
            event.register(UVKeybindManager.GUI_KEY);
            event.register(UVKeybindManager.RESTOCK);
            event.register(UVKeybindManager.SAVE);
            event.register(UVKeybindManager.LOAD);
        }
    }
}

