/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.utilityvest.common.menu;

import dev.satherov.utilityvest.common.capabilities.UVVestCapability;
import dev.satherov.utilityvest.common.item.UVVestItem;
import dev.satherov.utilityvest.core.annotations.NothingNull;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

@NothingNull
public abstract class UVVestMenu
extends AbstractContainerMenu {
    protected final int rows;
    protected UVVestCapability capability;
    protected ItemStack vestStack;

    public UVVestMenu(MenuType<?> menuType, int containerId, Inventory inventory, int rows) {
        super(menuType, containerId);
        ItemStack stack = UVVestItem.getVest(inventory, true);
        this.rows = rows;
        if (stack.isEmpty()) {
            inventory.player.closeContainer();
            return;
        }
        this.vestStack = stack;
        IItemHandler handler = (IItemHandler)this.vestStack.getCapability(Capabilities.ItemHandler.ITEM);
        if (handler == null) {
            inventory.player.closeContainer();
            return;
        }
        if (handler instanceof UVVestCapability) {
            UVVestCapability cap;
            this.capability = cap = (UVVestCapability)handler;
        }
        int yOffset = (rows - 4) * 18;
        this.addVestSlots(inventory, this.capability, yOffset);
    }

    private static ItemStack cloneStack(ItemStack stack, int size) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack copy = stack.copy();
        copy.setCount(size);
        return copy;
    }

    protected void addVestSlots(Inventory inventory, UVVestCapability handler, int yOffset) {
        for (int inv = 0; inv < 3; ++inv) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.addSlot(new Slot((Container)inventory, j1 + inv * 9 + 9, 8 + j1 * 18, 103 + inv * 18 + yOffset));
            }
        }
        for (int hotbar = 0; hotbar < 9; ++hotbar) {
            this.addSlot(new Slot((Container)inventory, hotbar, 8 + hotbar * 18, 161 + yOffset));
        }
    }

    public boolean moveItemStackTo(ItemStack stack, int start, int length, boolean reverse) {
        int maxStack;
        ItemStack existingStack;
        Slot slot;
        int i;
        int iterOrder;
        boolean successful = false;
        int n = iterOrder = !reverse ? 1 : -1;
        if (stack.isStackable()) {
            for (i = !reverse ? start : length - 1; !stack.isEmpty() && (!reverse && i < length || reverse && i >= start); i += iterOrder) {
                int remaining;
                int toTransfer;
                slot = (Slot)this.slots.get(i);
                existingStack = slot.getItem();
                if (existingStack.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)existingStack)) continue;
                maxStack = Math.min(stack.getMaxStackSize(), slot.getMaxStackSize());
                if (!slot.mayPlace(UVVestMenu.cloneStack(stack, 1)) || (toTransfer = Math.min(remaining = maxStack - existingStack.getCount(), stack.getCount())) <= 0) continue;
                stack.shrink(toTransfer);
                existingStack.grow(toTransfer);
                slot.set(existingStack);
                successful = true;
            }
        }
        if (!stack.isEmpty()) {
            int n2 = i = !reverse ? start : length - 1;
            while (!stack.isEmpty() && (!reverse && i < length || reverse && i >= start)) {
                slot = (Slot)this.slots.get(i);
                existingStack = slot.getItem();
                if (existingStack.isEmpty() && slot.mayPlace(UVVestMenu.cloneStack(stack, 1))) {
                    maxStack = Math.min(stack.getMaxStackSize(), slot.getMaxStackSize());
                    int toTransfer = Math.min(maxStack, stack.getCount());
                    ItemStack newStack = stack.copy();
                    newStack.setCount(toTransfer);
                    slot.set(newStack);
                    stack.shrink(toTransfer);
                    successful = true;
                }
                i += iterOrder;
            }
        }
        return successful;
    }

    public UVVestCapability getCapability() {
        return this.capability;
    }

    public int getRows() {
        return this.rows;
    }

    public boolean stillValid(Player player) {
        return !UVVestItem.getVest(player, true).isEmpty() && !player.isSpectator();
    }
}

