/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.utilityvest.datagen;

import dev.satherov.utilityvest.datagen.UVDataProvider;
import dev.satherov.utilityvest.datagen.assets.UVItemModelProvider;
import dev.satherov.utilityvest.datagen.assets.UVLanguageProvider;
import dev.satherov.utilityvest.datagen.data.UVRecipeProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.registries.VanillaRegistries;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="utilityvest", bus=EventBusSubscriber.Bus.MOD)
public class UVDataGenerator {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        CompletableFuture<HolderLookup.Provider> lookupProvider = CompletableFuture.supplyAsync(VanillaRegistries::createLookup, Util.backgroundExecutor());
        UVDataProvider provider = new UVDataProvider();
        provider.addSubProvider(event.includeClient(), (DataProvider)new UVLanguageProvider(packOutput));
        provider.addSubProvider(event.includeClient(), (DataProvider)new UVItemModelProvider(packOutput, fileHelper));
        provider.addSubProvider(event.includeServer(), (DataProvider)new UVRecipeProvider(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)provider);
    }
}

