/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.utilityvest.network;

import dev.satherov.utilityvest.common.item.UVVestItem;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record OpenVestPayload(boolean filter, int maxBanks) implements CustomPacketPayload
{
    public static final StreamCodec<FriendlyByteBuf, OpenVestPayload> STREAM_CODEC = CustomPacketPayload.codec(OpenVestPayload::encode, OpenVestPayload::new);
    public static final CustomPacketPayload.Type<OpenVestPayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"utilityvest", (String)"open_vest_menu"));

    private OpenVestPayload(FriendlyByteBuf buf) {
        this(buf.readBoolean(), buf.readInt());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeBoolean(this.filter);
        buf.writeInt(this.maxBanks);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static class Handler {
        public static void handle(OpenVestPayload msg, IPayloadContext ctx) {
            ctx.enqueueWork(() -> {
                Item patt1$temp;
                Player patt0$temp;
                if (!ctx.flow().isServerbound() || !((patt0$temp = ctx.player()) instanceof ServerPlayer)) {
                    return;
                }
                ServerPlayer player = (ServerPlayer)patt0$temp;
                ItemStack stack = UVVestItem.getVest((Player)player, true);
                if (!stack.isEmpty() && (patt1$temp = stack.getItem()) instanceof UVVestItem) {
                    UVVestItem vest = (UVVestItem)patt1$temp;
                    if (msg.filter) {
                        player.openMenu(vest.getFilterMenu());
                    } else {
                        player.openMenu(vest.getInventoryMenu());
                    }
                }
            }).exceptionally(e -> {
                ctx.disconnect((Component)Component.translatable((String)"network.utilityvest.open_menu.failed", (Object[])new Object[]{e.getMessage()}));
                return null;
            });
        }
    }
}

