/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.gui;

import com.chaosthedude.naturescompass.NaturesCompass;
import com.chaosthedude.naturescompass.gui.BiomeInfoScreen;
import com.chaosthedude.naturescompass.gui.BiomeSearchList;
import com.chaosthedude.naturescompass.gui.NaturesCompassScreen;
import com.chaosthedude.naturescompass.sorting.DimensionSorting;
import com.chaosthedude.naturescompass.sorting.NameSorting;
import com.chaosthedude.naturescompass.sorting.SourceSorting;
import com.chaosthedude.naturescompass.sorting.TagsSorting;
import com.chaosthedude.naturescompass.util.BiomeUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BiomeSearchEntry
extends ObjectSelectionList.Entry<BiomeSearchEntry> {
    private final Minecraft mc;
    private final NaturesCompassScreen parentScreen;
    private final Biome biome;
    private final BiomeSearchList biomesList;
    private final String tags;
    private long lastClickTime;

    public BiomeSearchEntry(BiomeSearchList biomesList, Biome biome) {
        this.biomesList = biomesList;
        this.biome = biome;
        this.parentScreen = biomesList.getParentScreen();
        this.mc = Minecraft.getInstance();
        this.tags = BiomeUtils.getBiomeTags(this.parentScreen.level, biome);
    }

    public void render(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int par6, int par7, boolean par8, float par9) {
        String tagsLine;
        String title = this.parentScreen.getSortingCategory().getLocalizedName();
        Object value = this.parentScreen.getSortingCategory().getValue(this.biome);
        if (this.parentScreen.getSortingCategory() instanceof NameSorting || this.parentScreen.getSortingCategory() instanceof SourceSorting || this.parentScreen.getSortingCategory() instanceof TagsSorting || this.parentScreen.getSortingCategory() instanceof DimensionSorting) {
            title = I18n.get((String)"string.naturescompass.dimension", (Object[])new Object[0]);
            Optional<ResourceLocation> biomeKey = BiomeUtils.getKeyForBiome(this.parentScreen.level, this.biome);
            value = biomeKey.isPresent() ? BiomeUtils.dimensionKeysToString(NaturesCompass.dimensionKeysForAllowedBiomeKeys.get((Object)biomeKey.get())) : "";
        }
        if (this.mc.font.width(tagsLine = I18n.get((String)"string.naturescompass.tags", (Object[])new Object[0]) + ": " + this.tags) > this.biomesList.getRowWidth()) {
            tagsLine = this.mc.font.plainSubstrByWidth(tagsLine + "...", this.biomesList.getRowWidth()) + "...";
        }
        guiGraphics.drawString(this.mc.font, (Component)Component.literal((String)BiomeUtils.getBiomeNameForDisplay(this.parentScreen.level, this.biome)), left + 1, top + 1, 0xFFFFFF);
        Font font = this.mc.font;
        MutableComponent mutableComponent = Component.literal((String)(title + ": " + String.valueOf(value)));
        Objects.requireNonNull(this.mc.font);
        guiGraphics.drawString(font, (Component)mutableComponent, left + 1, top + 9 + 3, 0x808080);
        Font font2 = this.mc.font;
        MutableComponent mutableComponent2 = Component.literal((String)tagsLine);
        Objects.requireNonNull(this.mc.font);
        guiGraphics.drawString(font2, (Component)mutableComponent2, left + 1, top + 9 + 14, 0x808080);
        Font font3 = this.mc.font;
        MutableComponent mutableComponent3 = Component.translatable((String)"string.naturescompass.source").append((Component)Component.literal((String)(": " + BiomeUtils.getBiomeSource(this.parentScreen.level, this.biome))));
        Objects.requireNonNull(this.mc.font);
        guiGraphics.drawString(font3, (Component)mutableComponent3, left + 1, top + 9 + 25, 0x808080);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.biomesList.selectBiome(this);
            if (Util.getMillis() - this.lastClickTime < 250L) {
                this.searchForBiome();
                return true;
            }
            this.lastClickTime = Util.getMillis();
            return false;
        }
        return false;
    }

    public void searchForBiome() {
        this.mc.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
        this.parentScreen.searchForBiome(this.biome);
    }

    public void viewInfo() {
        this.mc.setScreen((Screen)new BiomeInfoScreen(this.parentScreen, this.biome));
    }

    public Component getNarration() {
        return Component.literal((String)BiomeUtils.getBiomeNameForDisplay(this.parentScreen.level, this.biome));
    }
}

