/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.block.render;

import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.client.extensions.common.IClientBlockExtensions;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.block.blockentity.FramedBlockEntity;
import xfacthd.framedblocks.api.block.render.ParticleHelper;
import xfacthd.framedblocks.api.camo.CamoContainer;
import xfacthd.framedblocks.api.camo.CamoContent;

public class FramedBlockRenderProperties
implements IClientBlockExtensions {
    public static final FramedBlockRenderProperties INSTANCE = new FramedBlockRenderProperties();

    protected FramedBlockRenderProperties() {
    }

    public boolean addHitEffects(BlockState state, Level level, HitResult target, ParticleEngine engine) {
        BlockEntity blockEntity;
        BlockHitResult hit = (BlockHitResult)target;
        boolean suppressed = FramedBlockRenderProperties.suppressParticles(state, level, hit.getBlockPos());
        if (!suppressed && (blockEntity = level.getBlockEntity(hit.getBlockPos())) instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            return this.addHitEffectsUnsuppressed(state, level, hit, be, engine);
        }
        return suppressed;
    }

    protected boolean addHitEffectsUnsuppressed(BlockState state, Level level, BlockHitResult hit, FramedBlockEntity be, ParticleEngine engine) {
        ParticleHelper.Client.addHitEffects(state, level, hit, be.getCamo().getContent(), engine);
        return true;
    }

    public boolean addDestroyEffects(BlockState state, Level level, BlockPos pos, ParticleEngine engine) {
        BlockEntity blockEntity;
        boolean suppressed = FramedBlockRenderProperties.suppressParticles(state, level, pos);
        if (!suppressed && (blockEntity = level.getBlockEntity(pos)) instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            return this.addDestroyEffectsUnsuppressed(state, level, pos, be, engine);
        }
        return suppressed;
    }

    protected boolean addDestroyEffectsUnsuppressed(BlockState state, Level level, BlockPos pos, FramedBlockEntity be, ParticleEngine engine) {
        ParticleHelper.Client.addDestroyEffects(state, level, pos, be.getCamo().getContent(), engine);
        return true;
    }

    public boolean playBreakSound(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            FramedBlockRenderProperties.playCamoBreakSound(level, pos, be.getCamo());
            return true;
        }
        return false;
    }

    protected static boolean suppressParticles(BlockState state, Level level, BlockPos pos) {
        IFramedBlock block;
        Block block2 = state.getBlock();
        if (block2 instanceof IFramedBlock && (block = (IFramedBlock)block2).getBlockType().allowMakingIntangible()) {
            return block.isIntangible(state, (BlockGetter)level, pos, null);
        }
        return false;
    }

    protected static void playCamoBreakSound(Level level, BlockPos pos, CamoContainer<?, ?> camoContainer) {
        SoundType type = ((CamoContent)camoContainer.getContent()).getSoundType();
        SoundEvent sound = type.getBreakSound();
        level.playLocalSound(pos, sound, SoundSource.BLOCKS, (type.getVolume() + 1.0f) / 2.0f, type.getPitch() * 0.8f, false);
    }
}

