/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.model.quad;

import com.google.common.base.Preconditions;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import org.joml.AxisAngle4f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import xfacthd.framedblocks.api.model.quad.QuadData;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.util.ModelUtils;
import xfacthd.framedblocks.api.util.Utils;

public final class Modifiers {
    private static final QuadModifier.Modifier NOOP_MODIFIER = data -> true;
    private static final float SCALE_ROTATION_45 = 1.0f / (float)Math.cos(0.7853981633974483) - 1.0f;
    private static final float SCALE_ROTATION_22_5 = 1.0f / (float)Math.cos(0.39269908169872414) - 1.0f;
    private static final Vector3f ONE = new Vector3f(1.0f, 1.0f, 1.0f);
    private static final Vector3f CENTER = new Vector3f(0.5f, 0.5f, 0.5f);
    private static final Vector3f BOTTOM_CENTER = new Vector3f(0.5f, 0.0f, 0.5f);
    private static final Vector3f TOP_CENTER = new Vector3f(0.5f, 1.0f, 0.5f);
    private static final float PRISM_TILT_ANGLE = (float)Math.toDegrees(Math.atan(0.5));
    private static final Vector3f[] PRISM_DIR_TO_ORIGIN_VECS = new Vector3f[]{new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(0.0f, 1.0f, 1.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f)};
    private static final Vector3f SCALE_HORIZONTAL = new Vector3f(1.0f, 0.0f, 1.0f);
    private static final Vector3f[] HORIZONTAL_ORIGINS = new Vector3f[]{new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.0f, 1.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, 0.0f)};
    private static final Vector3f SCALE_VERT_X = new Vector3f(1.0f, 1.0f, 0.0f);
    private static final Vector3f SCALE_VERT_Z = new Vector3f(0.0f, 1.0f, 1.0f);
    private static final Vector3f[] VERTICAL_ORIGINS = new Vector3f[]{new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 1.0f, 1.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.0f, 0.0f)};

    public static QuadModifier.Modifier cut(Direction cutDir, float length) {
        if (Mth.equal((float)length, (float)1.0f)) {
            return NOOP_MODIFIER;
        }
        return Modifiers.cut(cutDir, length, length);
    }

    public static QuadModifier.Modifier cut(Direction cutDir, float lengthRightTop, float lengthLeftBottom) {
        return data -> Modifiers.cut(data, cutDir, lengthRightTop, lengthLeftBottom);
    }

    private static boolean cut(QuadData data, Direction cutDir, float lengthRightTop, float lengthLeftBottom) {
        Direction quadDir = data.quad().getDirection();
        Preconditions.checkState((quadDir.getAxis() != cutDir.getAxis() ? 1 : 0) != 0, (Object)"Cut direction must be prependicular to the quad direction");
        if (Utils.isY(quadDir)) {
            return Modifiers.cutTopBottom(data, cutDir, lengthRightTop, lengthLeftBottom);
        }
        if (Utils.isY(cutDir)) {
            return Modifiers.cutSideUpDown(data, cutDir == Direction.DOWN, lengthRightTop, lengthLeftBottom);
        }
        return Modifiers.cutSideLeftRight(data, cutDir == quadDir.getClockWise(), lengthRightTop, lengthLeftBottom);
    }

    public static QuadModifier.Modifier cutTopBottom(Direction cutDir, float length) {
        if (Mth.equal((float)length, (float)1.0f)) {
            return NOOP_MODIFIER;
        }
        return Modifiers.cutTopBottom(cutDir, length, length);
    }

    public static QuadModifier.Modifier cutTopBottom(Direction cutDir, float lengthRight, float lengthLeft) {
        Preconditions.checkState((!Utils.isY(cutDir) ? 1 : 0) != 0, (Object)"Cut direction must be horizontal");
        return data -> Modifiers.cutTopBottom(data, cutDir, lengthRight, lengthLeft);
    }

    private static boolean cutTopBottom(QuadData data, Direction cutDir, float lengthR, float lengthL) {
        float toXZ2;
        int coordIdx;
        int vertIdxR;
        float factorR;
        int idxR;
        boolean up;
        Direction quadDir = data.quad().getDirection();
        Preconditions.checkState((boolean)Utils.isY(quadDir), (Object)"Quad direction must be vertical");
        Preconditions.checkState((quadDir.getAxis() != cutDir.getAxis() ? 1 : 0) != 0, (Object)"Cut direction must be prependicular to the quad direction");
        boolean xAxis = Utils.isX(cutDir);
        boolean positive = Utils.isPositive(cutDir);
        boolean bl = up = quadDir == Direction.UP;
        if (cutDir == Direction.NORTH || !up && cutDir == Direction.EAST || up && cutDir == Direction.WEST) {
            float temp = lengthR;
            lengthR = lengthL;
            lengthL = temp;
        }
        int n = xAxis ? (positive ? 2 : 1) : (idxR = up == positive ? 1 : 0);
        int idxL = xAxis ? (positive ? 3 : 0) : (up == positive ? 2 : 3);
        Direction perpDir = cutDir.getCounterClockWise();
        boolean perpX = Utils.isX(perpDir);
        float f = perpX ? data.pos(idxR, 0) : (factorR = up ? 1.0f - data.pos(idxR, 2) : data.pos(idxR, 2));
        float factorL = perpX ? data.pos(idxL, 0) : (up ? 1.0f - data.pos(idxL, 2) : data.pos(idxL, 2));
        float targetR = Mth.lerp((float)factorR, (float)(positive ? lengthR : 1.0f - lengthR), (float)(positive ? lengthL : 1.0f - lengthL));
        float targetL = Mth.lerp((float)factorL, (float)(positive ? lengthR : 1.0f - lengthR), (float)(positive ? lengthL : 1.0f - lengthL));
        int n2 = xAxis ? (positive ? 1 : 3) : (up ? (positive ? 0 : 2) : (vertIdxR = positive ? 1 : 3));
        int vertIdxL = xAxis ? (positive ? 0 : 2) : (up ? (positive ? 3 : 1) : (positive ? 2 : 0));
        int n3 = coordIdx = xAxis ? 0 : 2;
        if (positive && (Utils.isHigher(data.pos(vertIdxR, coordIdx), targetR) || Utils.isHigher(data.pos(vertIdxL, coordIdx), targetL))) {
            return false;
        }
        if (!positive && (Utils.isLower(data.pos(vertIdxR, coordIdx), targetR) || Utils.isLower(data.pos(vertIdxL, coordIdx), targetL))) {
            return false;
        }
        float xz1 = data.pos(idxR, coordIdx);
        float xz2 = data.pos(idxL, coordIdx);
        float toXZ1 = positive ? Math.min(xz1, targetR) : Math.max(xz1, targetR);
        float f2 = toXZ2 = positive ? Math.min(xz2, targetL) : Math.max(xz2, targetL);
        if (Mth.equal((float)xz1, (float)toXZ1) && Mth.equal((float)xz2, (float)toXZ2)) {
            return true;
        }
        boolean rotated = data.uvRotated();
        TextureAtlasSprite sprite = data.quad().getSprite();
        if (xAxis) {
            ModelUtils.remapUV(sprite, data, data.pos(1, coordIdx), data.pos(2, coordIdx), toXZ1, 1, 2, idxR, false, rotated);
            ModelUtils.remapUV(sprite, data, data.pos(0, coordIdx), data.pos(3, coordIdx), toXZ2, 0, 3, idxL, false, rotated);
        } else {
            ModelUtils.remapUV(sprite, data, data.pos(1, coordIdx), data.pos(0, coordIdx), toXZ1, 0, 1, idxR, true, rotated);
            ModelUtils.remapUV(sprite, data, data.pos(2, coordIdx), data.pos(3, coordIdx), toXZ2, 3, 2, idxL, true, rotated);
        }
        data.pos(idxR, coordIdx, toXZ1);
        data.pos(idxL, coordIdx, toXZ2);
        return true;
    }

    public static QuadModifier.Modifier cutSideUpDown(float length) {
        return data -> Modifiers.cutSideUpDown(data, false, length, length) && Modifiers.cutSideUpDown(data, true, length, length);
    }

    public static QuadModifier.Modifier cutSideUpDown(boolean downwards, float length) {
        if (Mth.equal((float)length, (float)1.0f)) {
            return NOOP_MODIFIER;
        }
        return Modifiers.cutSideUpDown(downwards, length, length);
    }

    public static QuadModifier.Modifier cutSideUpDown(boolean downwards, float lengthRight, float lengthLeft) {
        return data -> Modifiers.cutSideUpDown(data, downwards, lengthRight, lengthLeft);
    }

    private static boolean cutSideUpDown(QuadData data, boolean downwards, float lengthRight, float lengthLeft) {
        float toY2;
        float factorR;
        Direction quadDir = data.quad().getDirection();
        Preconditions.checkState((!Utils.isY(quadDir) ? 1 : 0) != 0, (Object)"Quad direction must be horizontal");
        Direction quadDirRot = quadDir.getCounterClockWise();
        boolean x = Utils.isX(quadDirRot);
        boolean positive = Utils.isPositive(quadDirRot);
        float f = positive ? data.pos(0, x ? 0 : 2) : (factorR = 1.0f - data.pos(0, x ? 0 : 2));
        float factorL = positive ? data.pos(3, x ? 0 : 2) : 1.0f - data.pos(3, x ? 0 : 2);
        float targetR = Mth.lerp((float)factorR, (float)(downwards ? 1.0f - lengthRight : lengthRight), (float)(downwards ? 1.0f - lengthLeft : lengthLeft));
        float targetL = Mth.lerp((float)factorL, (float)(downwards ? 1.0f - lengthRight : lengthRight), (float)(downwards ? 1.0f - lengthLeft : lengthLeft));
        if (downwards && (Utils.isLower(data.pos(0, 1), targetR) || Utils.isLower(data.pos(3, 1), targetL))) {
            return false;
        }
        if (!downwards && (Utils.isHigher(data.pos(1, 1), targetR) || Utils.isHigher(data.pos(2, 1), targetL))) {
            return false;
        }
        int idx1 = downwards ? 1 : 0;
        int idx2 = downwards ? 2 : 3;
        float y1 = data.pos(idx1, 1);
        float y2 = data.pos(idx2, 1);
        float toY1 = downwards ? Math.max(y1, targetR) : Math.min(y1, targetR);
        float f2 = toY2 = downwards ? Math.max(y2, targetL) : Math.min(y2, targetL);
        if (Mth.equal((float)y1, (float)toY1) && Mth.equal((float)y2, (float)toY2)) {
            return true;
        }
        boolean rotated = data.uvRotated();
        TextureAtlasSprite sprite = data.quad().getSprite();
        ModelUtils.remapUV(sprite, data, data.pos(1, 1), data.pos(0, 1), toY1, 0, 1, idx1, true, rotated);
        ModelUtils.remapUV(sprite, data, data.pos(2, 1), data.pos(3, 1), toY2, 3, 2, idx2, true, rotated);
        data.pos(idx1, 1, toY1);
        data.pos(idx2, 1, toY2);
        return true;
    }

    public static QuadModifier.Modifier cutSideLeftRight(Direction cutDir, float length) {
        return Modifiers.cutSideLeftRight(cutDir, length, length);
    }

    public static QuadModifier.Modifier cutSideLeftRight(Direction cutDir, float lengthTop, float lengthBottom) {
        Preconditions.checkState((!Utils.isY(cutDir) ? 1 : 0) != 0, (Object)"Cut direction must be horizontal");
        return data -> {
            Direction quadDir = data.quad().getDirection();
            return Modifiers.cutSideLeftRight(data, cutDir == quadDir.getClockWise(), lengthTop, lengthBottom);
        };
    }

    public static QuadModifier.Modifier cutSideLeftRight(float length) {
        return data -> Modifiers.cutSideLeftRight(data, false, length, length) && Modifiers.cutSideLeftRight(data, true, length, length);
    }

    public static QuadModifier.Modifier cutSideLeftRight(boolean towardsRight, float length) {
        return Modifiers.cutSideLeftRight(towardsRight, length, length);
    }

    public static QuadModifier.Modifier cutSideLeftRight(boolean towardsRight, float lengthTop, float lengthBottom) {
        return data -> Modifiers.cutSideLeftRight(data, towardsRight, lengthTop, lengthBottom);
    }

    private static boolean cutSideLeftRight(QuadData data, boolean towardsRight, float lengthTop, float lengthBot) {
        float toXZ2;
        Direction quadDir = data.quad().getDirection();
        Preconditions.checkState((!Utils.isY(quadDir) ? 1 : 0) != 0, (Object)"Quad direction must be horizontal");
        boolean positive = Utils.isPositive(towardsRight ? quadDir.getCounterClockWise() : quadDir.getClockWise());
        int coordIdx = Utils.isX(quadDir) ? 2 : 0;
        int vertIdxTop = towardsRight ? 3 : 0;
        int vertIdxBot = towardsRight ? 2 : 1;
        float targetTop = Mth.lerp((float)(1.0f - data.pos(vertIdxTop, 1)), (float)(positive ? 1.0f - lengthTop : lengthTop), (float)(positive ? 1.0f - lengthBot : lengthBot));
        float targetBot = Mth.lerp((float)(1.0f - data.pos(vertIdxBot, 1)), (float)(positive ? 1.0f - lengthTop : lengthTop), (float)(positive ? 1.0f - lengthBot : lengthBot));
        if (positive && (Utils.isLower(data.pos(vertIdxTop, coordIdx), targetTop) || Utils.isLower(data.pos(vertIdxBot, coordIdx), targetBot))) {
            return false;
        }
        if (!positive && (Utils.isHigher(data.pos(vertIdxTop, coordIdx), targetTop) || Utils.isHigher(data.pos(vertIdxBot, coordIdx), targetBot))) {
            return false;
        }
        int idx1 = towardsRight ? 0 : 3;
        int idx2 = towardsRight ? 1 : 2;
        float xz1 = data.pos(idx1, coordIdx);
        float xz2 = data.pos(idx2, coordIdx);
        float toXZ1 = positive ? Math.max(xz1, targetTop) : Math.min(xz1, targetTop);
        float f = toXZ2 = positive ? Math.max(xz2, targetBot) : Math.min(xz2, targetBot);
        if (Mth.equal((float)xz1, (float)toXZ1) && Mth.equal((float)xz2, (float)toXZ2)) {
            return true;
        }
        boolean rotated = data.uvRotated();
        TextureAtlasSprite sprite = data.quad().getSprite();
        ModelUtils.remapUV(sprite, data, data.pos(0, coordIdx), data.pos(3, coordIdx), toXZ1, 0, 3, idx1, false, rotated);
        ModelUtils.remapUV(sprite, data, data.pos(1, coordIdx), data.pos(2, coordIdx), toXZ2, 1, 2, idx2, false, rotated);
        data.pos(idx1, coordIdx, toXZ1);
        data.pos(idx2, coordIdx, toXZ2);
        return true;
    }

    public static QuadModifier.Modifier cutTopBottom(float minX, float minZ, float maxX, float maxZ) {
        return data -> {
            Direction quadDir = data.quad().getDirection();
            Preconditions.checkState((boolean)Utils.isY(quadDir), (Object)"Quad direction must be vertical");
            return Modifiers.cutTopBottom(data, Direction.WEST, 1.0f - minX, 1.0f - minX) && Modifiers.cutTopBottom(data, Direction.EAST, maxX, maxX) && Modifiers.cutTopBottom(data, Direction.NORTH, 1.0f - minZ, 1.0f - minZ) && Modifiers.cutTopBottom(data, Direction.SOUTH, maxZ, maxZ);
        };
    }

    public static QuadModifier.Modifier cutTopBottom(Direction.Axis cutAxis, float length) {
        return data -> {
            Direction quadDir = data.quad().getDirection();
            Preconditions.checkState((boolean)Utils.isY(quadDir), (Object)"Quad direction must be vertical");
            Preconditions.checkState((quadDir.getAxis() != cutAxis ? 1 : 0) != 0, (Object)"Cutting axis must be perpendicular to quad axis");
            Direction posDir = Direction.fromAxisAndDirection((Direction.Axis)cutAxis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
            Direction negDir = Direction.fromAxisAndDirection((Direction.Axis)cutAxis, (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE);
            return Modifiers.cutTopBottom(data, posDir, length, length) && Modifiers.cutTopBottom(data, negDir, length, length);
        };
    }

    public static QuadModifier.Modifier cutSide(float minXZ, float minY, float maxXZ, float maxY) {
        return data -> {
            Direction quadDir = data.quad().getDirection();
            Preconditions.checkState((!Utils.isY(quadDir) ? 1 : 0) != 0, (Object)"Quad direction must be horizontal");
            boolean rightPositive = Utils.isPositive(quadDir.getClockWise());
            float leftXZ = rightPositive ? 1.0f - minXZ : maxXZ;
            float rightXZ = rightPositive ? maxXZ : 1.0f - minXZ;
            return Modifiers.cutSideLeftRight(data, true, rightXZ, rightXZ) && Modifiers.cutSideLeftRight(data, false, leftXZ, leftXZ) && Modifiers.cutSideUpDown(data, true, 1.0f - minY, 1.0f - minY) && Modifiers.cutSideUpDown(data, false, maxY, maxY);
        };
    }

    public static QuadModifier.Modifier cutSide(Direction cutDir, float lengthCW, float lengthCCW) {
        return data -> {
            Direction quadDir = data.quad().getDirection();
            Preconditions.checkState((!Utils.isY(quadDir) ? 1 : 0) != 0, (Object)"Quad direction must be horizontal");
            Preconditions.checkState((quadDir.getAxis() != cutDir.getAxis() ? 1 : 0) != 0, (Object)"Cut direction must be prependicular to the quad direction");
            if (Utils.isY(cutDir)) {
                boolean down = cutDir == Direction.DOWN;
                float lenRight = down ? lengthCW : lengthCCW;
                float lenLeft = down ? lengthCCW : lengthCW;
                return Modifiers.cutSideUpDown(data, down, lenRight, lenLeft);
            }
            boolean right = cutDir == quadDir.getClockWise();
            float lenTop = right ? lengthCW : lengthCCW;
            float lenBottom = right ? lengthCCW : lengthCW;
            return Modifiers.cutSideLeftRight(data, right, lenTop, lenBottom);
        };
    }

    public static QuadModifier.Modifier cutPrismTriangle(boolean up, boolean back) {
        return data -> {
            float angle;
            Direction quadDir = data.quad().getDirection();
            Preconditions.checkArgument((!Utils.isY(quadDir) ? 1 : 0) != 0, (Object)"Quad direction must not be on the Y axis");
            boolean leftCut = Modifiers.cutSideLeftRight(data, false, up ? 0.5f : 1.0f, up ? 1.0f : 0.5f);
            boolean rightCut = Modifiers.cutSideLeftRight(data, true, up ? 0.5f : 1.0f, up ? 1.0f : 0.5f);
            if (!leftCut && !rightCut) {
                return false;
            }
            boolean northeast = quadDir == Direction.NORTH || quadDir == Direction.EAST;
            Vector3f origin = PRISM_DIR_TO_ORIGIN_VECS[quadDir.ordinal() - 2 + (up ? 0 : 4)];
            float f = angle = back ? PRISM_TILT_ANGLE : -PRISM_TILT_ANGLE;
            if (northeast != up) {
                angle *= -1.0f;
            }
            Modifiers.rotate(data, quadDir.getClockWise().getAxis(), origin, angle, true);
            Modifiers.rotate(data, Direction.Axis.Y, origin, 45.0f, true);
            return true;
        };
    }

    public static QuadModifier.Modifier cutPrismTriangle(Direction cutDir, boolean back) {
        Preconditions.checkArgument((!Utils.isY(cutDir) ? 1 : 0) != 0, (Object)"Cut direction must be horizontal");
        return data -> {
            Vector3f origin;
            boolean southwest;
            Direction quadDir = data.quad().getDirection();
            Preconditions.checkArgument((boolean)Utils.isY(quadDir), (Object)"Quad direction must be on the Y axis");
            boolean leftCut = Modifiers.cutTopBottom(data, cutDir.getCounterClockWise(), 0.5f, 1.0f);
            boolean rightCut = Modifiers.cutTopBottom(data, cutDir.getClockWise(), 1.0f, 0.5f);
            if (!leftCut && !rightCut) {
                return false;
            }
            boolean up = quadDir == Direction.UP;
            boolean bl = southwest = cutDir == Direction.SOUTH || cutDir == Direction.WEST;
            if (back) {
                origin = PRISM_DIR_TO_ORIGIN_VECS[cutDir.ordinal() - 2 + (!up ? 0 : 4)];
            } else {
                Modifiers.offset(data, cutDir, 0.5f);
                origin = up ? TOP_CENTER : BOTTOM_CENTER;
            }
            float angle = up ? PRISM_TILT_ANGLE : -PRISM_TILT_ANGLE;
            angle = (up ? 90.0f : -90.0f) - angle;
            if (southwest == back) {
                angle *= -1.0f;
            }
            Modifiers.rotate(data, cutDir.getClockWise().getAxis(), origin, angle, true);
            Modifiers.rotate(data, Direction.Axis.Y, CENTER, 45.0f, true);
            return true;
        };
    }

    public static QuadModifier.Modifier cutSmallTriangle(Direction cutDir) {
        return data -> {
            boolean right;
            boolean left;
            Direction quadDir = data.quad().getDirection();
            Preconditions.checkArgument((!Utils.isY(quadDir) || !Utils.isY(cutDir) ? 1 : 0) != 0, (Object)"Cut direction cannot be along the Y axis for quads pointing along the Y axis");
            if (!Modifiers.cut(data, cutDir, 0.5f, 0.5f)) {
                return false;
            }
            if (Utils.isY(cutDir)) {
                boolean up = cutDir == Direction.UP;
                left = Modifiers.cutSideLeftRight(data, false, up ? 0.0f : 1.0f, up ? 1.0f : 0.0f);
                right = Modifiers.cutSideLeftRight(data, true, up ? 0.0f : 1.0f, up ? 1.0f : 0.0f);
            } else if (Utils.isY(quadDir)) {
                left = Modifiers.cutTopBottom(data, cutDir.getCounterClockWise(), 0.0f, 1.0f);
                right = Modifiers.cutTopBottom(data, cutDir.getClockWise(), 1.0f, 0.0f);
            } else {
                boolean cutRight = cutDir == quadDir.getClockWise();
                left = Modifiers.cutSideUpDown(data, false, cutRight ? 0.0f : 1.0f, cutRight ? 1.0f : 0.0f);
                right = Modifiers.cutSideUpDown(data, true, cutRight ? 0.0f : 1.0f, cutRight ? 1.0f : 0.0f);
            }
            return left || right;
        };
    }

    public static QuadModifier.Modifier makeHorizontalSlope(boolean rightEdge, float angle) {
        return data -> {
            Direction dir = data.quad().getDirection();
            if (!rightEdge) {
                dir = dir.getClockWise();
            }
            Vector3f origin = HORIZONTAL_ORIGINS[dir.ordinal() - 2];
            float rotAngle = rightEdge ? -angle : angle;
            Modifiers.rotate(data, Direction.Axis.Y, origin, rotAngle, true, SCALE_HORIZONTAL);
            return true;
        };
    }

    public static QuadModifier.Modifier makeVerticalSlope(boolean topEdge, float angle) {
        return data -> {
            Direction dir = data.quad().getDirection();
            Direction.Axis axis = dir.getClockWise().getAxis();
            Vector3f origin = VERTICAL_ORIGINS[dir.ordinal() - 2 + (topEdge ? 4 : 0)];
            float rotAngle = Utils.isPositive(dir.getClockWise()) != topEdge ? -angle : angle;
            Vector3f scaleVec = Utils.isX(dir) ? SCALE_VERT_X : SCALE_VERT_Z;
            Modifiers.rotate(data, axis, origin, rotAngle, true, scaleVec);
            return true;
        };
    }

    public static QuadModifier.Modifier makeVerticalSlope(Direction edge, float angle) {
        return data -> {
            Direction dir = data.quad().getDirection();
            boolean top = dir == Direction.UP;
            Preconditions.checkArgument((boolean)Utils.isY(dir), (Object)"Quad direction must be on the Y axis");
            Preconditions.checkArgument((!Utils.isY(edge) ? 1 : 0) != 0, (Object)"Edge direction must be horizontal");
            Direction.Axis axis = edge.getClockWise().getAxis();
            Vector3f origin = VERTICAL_ORIGINS[edge.getOpposite().ordinal() - 2 + (top ? 0 : 4)];
            float rotAngle = Utils.isPositive(edge.getClockWise()) != top ? angle : -angle;
            Vector3f scaleVec = Utils.isX(edge) ? SCALE_VERT_X : SCALE_VERT_Z;
            Modifiers.rotate(data, axis, origin, rotAngle, true, scaleVec);
            return true;
        };
    }

    public static QuadModifier.Modifier offset(Direction dir, float amount) {
        if (Mth.equal((float)amount, (float)0.0f)) {
            return NOOP_MODIFIER;
        }
        return data -> {
            Modifiers.offset(data, dir, amount);
            return true;
        };
    }

    private static void offset(QuadData data, Direction dir, float amount) {
        int idx = dir.getAxis().ordinal();
        float value = Utils.isPositive(dir) ? amount : -1.0f * amount;
        for (int i = 0; i < 4; ++i) {
            data.pos(i, idx, data.pos(i, idx) + value);
        }
    }

    public static QuadModifier.Modifier setPosition(float posTarget) {
        if (Mth.equal((float)posTarget, (float)1.0f)) {
            return NOOP_MODIFIER;
        }
        return data -> {
            int idx = data.quad().getDirection().getAxis().ordinal();
            float value = Utils.isPositive(data.quad().getDirection()) ? posTarget : 1.0f - posTarget;
            for (int i = 0; i < 4; ++i) {
                data.pos(i, idx, value);
            }
            return true;
        };
    }

    public static QuadModifier.Modifier setPosition(float[] posTarget) {
        Preconditions.checkArgument((posTarget.length == 4 ? 1 : 0) != 0, (Object)"Target position array must contain 4 elements!");
        return data -> {
            Direction dir = data.quad().getDirection();
            int idx = dir.getAxis().ordinal();
            boolean positive = Utils.isPositive(dir);
            boolean y = Utils.isY(dir);
            Direction ccwDir = y ? dir : dir.getCounterClockWise();
            boolean ccwPositive = Utils.isPositive(ccwDir);
            int lerpXIdx = y ? 0 : ccwDir.getAxis().ordinal();
            int lerpZIdx = y ? 2 : 1;
            boolean invLerpX = !y && !ccwPositive;
            boolean invLerpZ = !y || !ccwPositive;
            for (int i = 0; i < 4; ++i) {
                float x0 = invLerpX ? 1.0f - data.pos(i, lerpXIdx) : data.pos(i, lerpXIdx);
                float z0 = invLerpZ ? 1.0f - data.pos(i, lerpZIdx) : data.pos(i, lerpZIdx);
                float target = (float)Mth.lerp2((double)x0, (double)z0, (double)posTarget[0], (double)posTarget[3], (double)posTarget[1], (double)posTarget[2]);
                data.pos(i, idx, positive ? target : 1.0f - target);
            }
            return true;
        };
    }

    public static QuadModifier.Modifier rotateCentered(Direction.Axis axis, float angle, boolean rescale) {
        return Modifiers.rotate(axis, CENTER, angle, rescale);
    }

    public static QuadModifier.Modifier rotateCentered(Direction.Axis axis, float angle, boolean rescale, Vector3f scaleMult) {
        return Modifiers.rotate(axis, CENTER, angle, rescale, scaleMult);
    }

    public static QuadModifier.Modifier rotate(Direction.Axis axis, Vector3f origin, float angle, boolean rescale) {
        return data -> {
            Modifiers.rotate(data, axis, origin, angle, rescale);
            return true;
        };
    }

    private static void rotate(QuadData data, Direction.Axis axis, Vector3f origin, float angle, boolean rescale) {
        Modifiers.rotate(data, axis, origin, angle, rescale, ONE);
    }

    public static QuadModifier.Modifier rotate(Direction.Axis axis, Vector3f origin, float angle, boolean rescale, Vector3f scaleMult) {
        return data -> {
            Modifiers.rotate(data, axis, origin, angle, rescale, scaleMult);
            return true;
        };
    }

    private static void rotate(QuadData data, Direction.Axis axis, Vector3f origin, float angle, boolean rescale, Vector3f scaleMult) {
        Vector3f axisVec;
        Vector3f scaleVec = switch (axis) {
            case Direction.Axis.X -> {
                axisVec = new Vector3f(1.0f, 0.0f, 0.0f);
                yield new Vector3f(0.0f, 1.0f, 1.0f);
            }
            case Direction.Axis.Y -> {
                axisVec = new Vector3f(0.0f, 1.0f, 0.0f);
                yield new Vector3f(1.0f, 0.0f, 1.0f);
            }
            case Direction.Axis.Z -> {
                axisVec = new Vector3f(0.0f, 0.0f, 1.0f);
                yield new Vector3f(1.0f, 1.0f, 0.0f);
            }
            default -> throw new IllegalArgumentException("Invalid axis!");
        };
        float angleRad = (float)Math.toRadians(angle);
        Matrix4f transform = new Matrix4f().rotate(new AxisAngle4f(angleRad, (Vector3fc)axisVec));
        if (rescale) {
            float scaleAngle;
            float f = scaleAngle = Mth.abs((float)angle) > 45.0f ? 90.0f - Mth.abs((float)angle) : Mth.abs((float)angle);
            if (scaleAngle == 22.5f) {
                scaleVec.mul(SCALE_ROTATION_22_5);
            } else if (scaleAngle == 45.0f) {
                scaleVec.mul(SCALE_ROTATION_45);
            } else {
                float scaleFactor = 1.0f / (float)Math.cos(Math.PI / (180.0 / (double)scaleAngle)) - 1.0f;
                scaleVec.mul(scaleFactor);
            }
            scaleMult.absolute();
            scaleVec.mul(scaleMult.x(), scaleMult.y(), scaleMult.z());
            scaleVec.add(1.0f, 1.0f, 1.0f);
        }
        for (int i = 0; i < 4; ++i) {
            Vector4f vector4f = new Vector4f(data.pos(i, 0) - origin.x(), data.pos(i, 1) - origin.y(), data.pos(i, 2) - origin.z(), 1.0f);
            if (rescale) {
                vector4f.mul((Vector4fc)new Vector4f((Vector3fc)scaleVec, 1.0f));
            }
            vector4f.mul((Matrix4fc)transform);
            data.pos(i, 0, vector4f.x() + origin.x());
            data.pos(i, 1, vector4f.y() + origin.y());
            data.pos(i, 2, vector4f.z() + origin.z());
        }
    }

    public static QuadModifier.Modifier scaleFace(float factor, Vector3f origin) {
        return data -> {
            Vector3f scaleVec = switch (data.quad().getDirection().getAxis()) {
                default -> throw new MatchException(null, null);
                case Direction.Axis.X -> new Vector3f(0.0f, 1.0f, 1.0f);
                case Direction.Axis.Y -> new Vector3f(1.0f, 0.0f, 1.0f);
                case Direction.Axis.Z -> new Vector3f(1.0f, 1.0f, 0.0f);
            };
            scaleVec.mul(factor);
            for (int i = 0; i < 4; ++i) {
                Vector4f posVec = new Vector4f(data.pos(i, 0) - origin.x(), data.pos(i, 1) - origin.y(), data.pos(i, 2) - origin.z(), 1.0f);
                posVec.mul((Vector4fc)new Vector4f((Vector3fc)scaleVec, 1.0f));
                data.pos(i, 0, posVec.x() + origin.x());
                data.pos(i, 1, posVec.y() + origin.y());
                data.pos(i, 2, posVec.z() + origin.z());
            }
            return true;
        };
    }

    public static QuadModifier.Modifier applyFullbright() {
        return Modifiers.applyLightmap(15, 15);
    }

    public static QuadModifier.Modifier applyLightmap(int light) {
        return Modifiers.applyLightmap(light, light);
    }

    public static QuadModifier.Modifier applyLightmap(int blockLight, int skyLight) {
        Preconditions.checkArgument((blockLight >= 0 && blockLight < 16 ? 1 : 0) != 0, (Object)"Invalid block light value");
        Preconditions.checkArgument((skyLight >= 0 && skyLight < 16 ? 1 : 0) != 0, (Object)"Invalid sky light value");
        return data -> {
            for (int i = 0; i < 4; ++i) {
                data.light(i, LightTexture.pack((int)blockLight, (int)skyLight));
            }
            return true;
        };
    }

    private Modifiers() {
    }
}

