/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.pillar;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.Utils;

public class FramedPillarSocketGeometry
extends Geometry {
    private final Direction facing;

    public FramedPillarSocketGeometry(GeometryFactory.Context ctx) {
        this.facing = (Direction)ctx.state().getValue((Property)BlockStateProperties.FACING);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir = quad.getDirection();
        Direction.Axis quadAxis = quadDir.getAxis();
        if (quadDir == this.facing.getOpposite()) {
            boolean y = Utils.isY(quadDir);
            QuadModifier.of(quad).apply(y ? Modifiers.cutTopBottom(0.25f, 0.25f, 0.75f, 0.75f) : Modifiers.cutSide(0.25f, 0.25f, 0.75f, 0.75f)).export(quadMap.get(quadDir));
            Utils.forAllDirections(false, dir -> {
                if (dir.getAxis() == this.facing.getAxis()) {
                    return;
                }
                boolean perp = y ? Utils.isZ(dir) : Utils.isY(dir);
                QuadModifier.of(quad).apply(Modifiers.cut(dir, 0.25f)).applyIf(Modifiers.cut(dir.getClockWise(quadAxis), 0.75f), perp).applyIf(Modifiers.cut(dir.getCounterClockWise(quadAxis), 0.75f), perp).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
            });
        } else if (quadDir != this.facing) {
            QuadModifier.of(quad).apply(Modifiers.cut(this.facing.getOpposite(), 0.5f)).export(quadMap.get(quadDir));
            QuadModifier.of(quad).apply(Modifiers.cut(this.facing, 0.5f)).apply(Modifiers.cut(this.facing.getClockWise(quadAxis), 0.75f)).apply(Modifiers.cut(this.facing.getCounterClockWise(quadAxis), 0.75f)).apply(Modifiers.setPosition(0.75f)).export(quadMap.get(null));
        }
    }
}

