/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.slopepanelcorner;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector3f;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.model.wrapping.itemmodel.ItemModelInfo;
import xfacthd.framedblocks.api.model.wrapping.itemmodel.TranslatedItemModelInfo;
import xfacthd.framedblocks.client.model.slopepanel.FramedSlopePanelGeometry;

public class FramedSmallCornerSlopePanelGeometry
extends Geometry {
    private static final TranslatedItemModelInfo ITEM_MODEL_INFO = TranslatedItemModelInfo.hand(0.0f, 0.5f, -0.5f);
    private static final Vector3f ORIGIN_BOTTOM = new Vector3f(0.5f, 0.0f, 0.5f);
    private static final Vector3f ORIGIN_TOP = new Vector3f(0.5f, 1.0f, 0.5f);
    private final Direction dir;
    private final boolean top;
    private final boolean ySlope;

    public FramedSmallCornerSlopePanelGeometry(GeometryFactory.Context ctx) {
        this.dir = (Direction)ctx.state().getValue((Property)FramedProperties.FACING_HOR);
        this.top = (Boolean)ctx.state().getValue((Property)FramedProperties.TOP);
        this.ySlope = (Boolean)ctx.state().getValue((Property)FramedProperties.Y_SLOPE);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir = quad.getDirection();
        if (quadDir == this.dir || quadDir == this.dir.getCounterClockWise()) {
            Direction cutDir = quadDir == this.dir ? this.dir.getClockWise() : this.dir.getOpposite();
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(cutDir, this.top ? 0.5f : 0.0f, this.top ? 0.0f : 0.5f)).export(quadMap.get(quadDir));
        } else if (!(this.ySlope || quadDir != this.dir.getOpposite() && quadDir != this.dir.getClockWise())) {
            float angle;
            Direction cutDir = quadDir == this.dir.getOpposite() ? this.dir.getClockWise() : this.dir.getOpposite();
            float f = angle = this.top ? FramedSlopePanelGeometry.SLOPE_ANGLE : -FramedSlopePanelGeometry.SLOPE_ANGLE;
            if (quadDir == Direction.NORTH || quadDir == Direction.EAST) {
                angle *= -1.0f;
            }
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(cutDir, this.top ? 0.5f : 0.0f, this.top ? 0.0f : 0.5f)).apply(Modifiers.setPosition(0.5f)).apply(Modifiers.rotate(cutDir.getAxis(), this.top ? ORIGIN_TOP : ORIGIN_BOTTOM, angle, true)).export(quadMap.get(null));
        } else if (this.ySlope && (!this.top && quadDir == Direction.UP || this.top && quadDir == Direction.DOWN)) {
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getOpposite(), 0.0f, 0.5f)).apply(Modifiers.makeVerticalSlope(this.dir.getClockWise(), FramedSlopePanelGeometry.SLOPE_ANGLE_VERT)).export(quadMap.get(null));
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getClockWise(), 0.5f, 0.0f)).apply(Modifiers.makeVerticalSlope(this.dir.getOpposite(), FramedSlopePanelGeometry.SLOPE_ANGLE_VERT)).export(quadMap.get(null));
        } else if (!this.top && quadDir == Direction.DOWN || this.top && quadDir == Direction.UP) {
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getOpposite(), 0.5f)).apply(Modifiers.cutTopBottom(this.dir.getClockWise(), 0.5f)).export(quadMap.get(quadDir));
        }
    }

    @Override
    public ItemModelInfo getItemModelInfo() {
        return ITEM_MODEL_INFO;
    }
}

