/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.cube;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.blockentity.special.FramedCollapsibleBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.NullableDirection;

public class FramedCollapsibleBlock
extends FramedBlock {
    private static final Map<Integer, VoxelShape> SHAPE_CACHE = new ConcurrentHashMap<Integer, VoxelShape>();
    private static final double MIN_DEPTH = (double)2.0E-5f;

    public FramedCollapsibleBlock(BlockType blockType) {
        super(blockType, BlockBehaviour.Properties::dynamicShape);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)PropertyHolder.ROTATE_SPLIT_LINE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{PropertyHolder.NULLABLE_FACE, BlockStateProperties.WATERLOGGED, PropertyHolder.ROTATE_SPLIT_LINE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return ((PlacementStateBuilder)PlacementStateBuilder.of(this, ctx).withWater()).build();
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        BlockEntity blockEntity;
        ItemStack heldItem = player.getMainHandItem();
        if (heldItem.getItem() == FBContent.ITEM_FRAMED_WRENCH.value()) {
            boolean rotSplitLine = (Boolean)state.getValue((Property)PropertyHolder.ROTATE_SPLIT_LINE);
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)PropertyHolder.ROTATE_SPLIT_LINE, (Comparable)Boolean.valueOf(!rotSplitLine)));
            return true;
        }
        if (heldItem.getItem() == FBContent.ITEM_FRAMED_HAMMER.value() && (blockEntity = level.getBlockEntity(pos)) instanceof FramedCollapsibleBlockEntity) {
            FramedCollapsibleBlockEntity be = (FramedCollapsibleBlockEntity)blockEntity;
            if (!level.isClientSide()) {
                be.handleDeform(player);
            }
            return true;
        }
        return false;
    }

    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        BlockEntity blockEntity;
        if (this.isIntangible(state, level, pos, ctx)) {
            return Shapes.empty();
        }
        NullableDirection face = (NullableDirection)((Object)state.getValue(PropertyHolder.NULLABLE_FACE));
        if (face != NullableDirection.NONE && (blockEntity = level.getBlockEntity(pos)) instanceof FramedCollapsibleBlockEntity) {
            FramedCollapsibleBlockEntity be = (FramedCollapsibleBlockEntity)blockEntity;
            int offsets = be.getPackedOffsets(state);
            return SHAPE_CACHE.computeIfAbsent(offsets |= face.toDirection().get3DDataValue() << 20, FramedCollapsibleBlock::buildShape);
        }
        return Shapes.block();
    }

    @Override
    protected VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return Shapes.empty();
    }

    @Override
    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        super.setPlacedBy(level, pos, state, placer, stack);
        if (!level.isClientSide() && stack.get(DataComponents.BLOCK_ENTITY_DATA) != null && (blockEntity = level.getBlockEntity(pos)) instanceof FramedCollapsibleBlockEntity) {
            FramedCollapsibleBlockEntity be = (FramedCollapsibleBlockEntity)blockEntity;
            Direction collapseFace = be.getCollapsedFace();
            if (((NullableDirection)((Object)state.getValue(PropertyHolder.NULLABLE_FACE))).toDirection() != collapseFace) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue(PropertyHolder.NULLABLE_FACE, (Comparable)((Object)NullableDirection.fromDirection(collapseFace))));
            }
        }
    }

    @Override
    public boolean doesBlockOccludeBeaconBeam(BlockState state, LevelReader level, BlockPos pos) {
        NullableDirection face = (NullableDirection)((Object)state.getValue(PropertyHolder.NULLABLE_FACE));
        return face == NullableDirection.NONE || Utils.isY(face.toDirection());
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FramedCollapsibleBlockEntity(pos, state);
    }

    @Override
    public BlockState getItemModelSource() {
        return this.defaultBlockState();
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return state;
    }

    private static VoxelShape buildShape(Integer packedData) {
        Direction face = Direction.from3DDataValue((int)(packedData >> 20));
        byte[] offsets = FramedCollapsibleBlockEntity.unpackOffsets(packedData & 0xFFFFF);
        boolean positive = Utils.isPositive(face);
        boolean flipX = face == Direction.NORTH || face == Direction.EAST;
        boolean flipZ = face != Direction.UP;
        VoxelShape result = Shapes.empty();
        for (int x = 0; x < 4; ++x) {
            for (int z = 0; z < 4; ++z) {
                double x0 = flipX ? 1.0 - (double)x / 4.0 : (double)x / 4.0;
                double x1 = flipX ? 1.0 - (double)(x + 1) / 4.0 : (double)(x + 1) / 4.0;
                double z0 = flipZ ? 1.0 - (double)z / 4.0 : (double)z / 4.0;
                double z1 = flipZ ? 1.0 - (double)(z + 1) / 4.0 : (double)(z + 1) / 4.0;
                double y0 = Mth.lerp2((double)x0, (double)z0, (double)offsets[0], (double)offsets[3], (double)offsets[1], (double)offsets[2]);
                double y1 = Mth.lerp2((double)x1, (double)z1, (double)offsets[0], (double)offsets[3], (double)offsets[1], (double)offsets[2]);
                double y = Math.min(y0, y1);
                y = positive ? Math.max(16.0 - y, (double)2.0E-5f) : Math.min(y, 15.999980000000505);
                VoxelShape shape = switch (face) {
                    default -> throw new MatchException(null, null);
                    case Direction.NORTH -> FramedCollapsibleBlock.box((double)(x * 4), (double)(z * 4), (double)y, (double)((x + 1) * 4), (double)((z + 1) * 4), (double)16.0);
                    case Direction.EAST -> FramedCollapsibleBlock.box((double)0.0, (double)(z * 4), (double)(x * 4), (double)y, (double)((z + 1) * 4), (double)((x + 1) * 4));
                    case Direction.SOUTH -> FramedCollapsibleBlock.box((double)(x * 4), (double)(z * 4), (double)0.0, (double)((x + 1) * 4), (double)((z + 1) * 4), (double)y);
                    case Direction.WEST -> FramedCollapsibleBlock.box((double)y, (double)(z * 4), (double)(x * 4), (double)16.0, (double)((z + 1) * 4), (double)((x + 1) * 4));
                    case Direction.UP -> FramedCollapsibleBlock.box((double)(x * 4), (double)0.0, (double)(z * 4), (double)((x + 1) * 4), (double)y, (double)((z + 1) * 4));
                    case Direction.DOWN -> FramedCollapsibleBlock.box((double)(x * 4), (double)y, (double)(z * 4), (double)((x + 1) * 4), (double)16.0, (double)((z + 1) * 4));
                };
                result = ShapeUtils.orUnoptimized(result, shape);
            }
        }
        return result.optimize();
    }
}

