/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slopepanelcorner;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.block.slopepanelcorner.FramedCornerSlopePanelWallBlock;
import xfacthd.framedblocks.common.blockentity.doubled.slopepanelcorner.FramedExtendedDoubleCornerSlopePanelWallBlockEntity;
import xfacthd.framedblocks.common.blockentity.doubled.slopepanelcorner.FramedExtendedInnerDoubleCornerSlopePanelWallBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.doubleblock.CamoGetter;
import xfacthd.framedblocks.common.data.doubleblock.DoubleBlockTopInteractionMode;
import xfacthd.framedblocks.common.data.doubleblock.SolidityCheck;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;

public class FramedExtendedDoubleCornerSlopePanelWallBlock
extends AbstractFramedDoubleBlock {
    private final Holder<Block> nonWallBlock;

    public FramedExtendedDoubleCornerSlopePanelWallBlock(BlockType type) {
        super(type);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(true)));
        this.nonWallBlock = switch (type) {
            case BlockType.FRAMED_EXT_DOUBLE_CORNER_SLOPE_PANEL_W -> FBContent.BLOCK_FRAMED_EXTENDED_DOUBLE_CORNER_SLOPE_PANEL;
            case BlockType.FRAMED_EXT_INNER_DOUBLE_CORNER_SLOPE_PANEL_W -> FBContent.BLOCK_FRAMED_EXTENDED_INNER_DOUBLE_CORNER_SLOPE_PANEL;
            default -> throw new IllegalArgumentException("Unknown corner slope panel type: " + String.valueOf(type));
        };
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FramedProperties.FACING_HOR, PropertyHolder.ROTATION, FramedProperties.Y_SLOPE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return FramedCornerSlopePanelWallBlock.getStateForPlacement(this, ctx, this.getBlockType() == BlockType.FRAMED_EXT_DOUBLE_CORNER_SLOPE_PANEL_W);
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        if (face.getAxis() == dir.getAxis()) {
            HorizontalRotation rotation = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
            return (BlockState)state.setValue(PropertyHolder.ROTATION, (Comparable)((Object)rotation.rotate(rot)));
        }
        if (Utils.isY(face)) {
            return (BlockState)state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)rot.rotate(dir));
        }
        return state;
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        return this.rotate(state, (Direction)state.getValue((Property)FramedProperties.FACING_HOR), rot);
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return FramedCornerSlopePanelWallBlock.mirrorCornerPanel(state, mirror);
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return switch (this.getBlockType()) {
            case BlockType.FRAMED_EXT_DOUBLE_CORNER_SLOPE_PANEL_W -> new FramedExtendedDoubleCornerSlopePanelWallBlockEntity(pos, state);
            case BlockType.FRAMED_EXT_INNER_DOUBLE_CORNER_SLOPE_PANEL_W -> new FramedExtendedInnerDoubleCornerSlopePanelWallBlockEntity(pos, state);
            default -> throw new IllegalStateException("Unexpected type: " + String.valueOf(this.getBlockType()));
        };
    }

    @Override
    public Tuple<BlockState, BlockState> calculateBlockPair(BlockState state) {
        HorizontalRotation rot;
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation backRot = rot.rotate((rot = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION))).isVertical() ? Rotation.CLOCKWISE_90 : Rotation.COUNTERCLOCKWISE_90);
        boolean ySlope = (Boolean)state.getValue((Property)FramedProperties.Y_SLOPE);
        return switch (this.getBlockType()) {
            case BlockType.FRAMED_EXT_DOUBLE_CORNER_SLOPE_PANEL_W -> new Tuple((Object)((BlockState)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_EXTENDED_CORNER_SLOPE_PANEL_WALL.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir)).setValue(PropertyHolder.ROTATION, (Comparable)((Object)rot))).setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))), (Object)((BlockState)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL_WALL.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir.getOpposite())).setValue(PropertyHolder.ROTATION, (Comparable)((Object)backRot))).setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))));
            case BlockType.FRAMED_EXT_INNER_DOUBLE_CORNER_SLOPE_PANEL_W -> new Tuple((Object)((BlockState)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_EXTENDED_INNER_CORNER_SLOPE_PANEL_WALL.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir)).setValue(PropertyHolder.ROTATION, (Comparable)((Object)rot))).setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))), (Object)((BlockState)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_SMALL_CORNER_SLOPE_PANEL_WALL.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir.getOpposite())).setValue(PropertyHolder.ROTATION, (Comparable)((Object)backRot))).setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))));
            default -> throw new IllegalArgumentException("Invalid type for this block: " + String.valueOf(this.getBlockType()));
        };
    }

    @Override
    public DoubleBlockTopInteractionMode calculateTopInteractionMode(BlockState state) {
        HorizontalRotation rot = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
        if (rot == HorizontalRotation.UP || rot == HorizontalRotation.RIGHT) {
            return DoubleBlockTopInteractionMode.EITHER;
        }
        return DoubleBlockTopInteractionMode.SECOND;
    }

    @Override
    public CamoGetter calculateCamoGetter(BlockState state, Direction side, @Nullable Direction edge) {
        return switch (this.getBlockType()) {
            case BlockType.FRAMED_EXT_DOUBLE_CORNER_SLOPE_PANEL_W -> {
                Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
                if (side == dir) {
                    yield CamoGetter.FIRST;
                }
                HorizontalRotation rot = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
                Direction rotDir = rot.withFacing(dir);
                Direction perpRotDir = rot.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(dir);
                if (side == rotDir.getOpposite() || side == perpRotDir.getOpposite()) {
                    yield CamoGetter.SECOND;
                }
                if (side == dir.getOpposite() && (edge == rotDir.getOpposite() || edge == perpRotDir.getOpposite())) {
                    yield CamoGetter.SECOND;
                }
                if (side == rotDir) {
                    if (edge == dir || edge == perpRotDir) {
                        yield CamoGetter.FIRST;
                    }
                    if (edge == perpRotDir.getOpposite()) {
                        yield CamoGetter.SECOND;
                    }
                } else if (side == perpRotDir) {
                    if (edge == dir || edge == rotDir) {
                        yield CamoGetter.FIRST;
                    }
                    if (edge == rotDir.getOpposite()) {
                        yield CamoGetter.SECOND;
                    }
                }
                yield CamoGetter.NONE;
            }
            case BlockType.FRAMED_EXT_INNER_DOUBLE_CORNER_SLOPE_PANEL_W -> {
                Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
                HorizontalRotation rot = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
                Direction rotDir = rot.withFacing(dir);
                Direction perpRotDir = rot.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(dir);
                if (side == dir || side == rotDir.getOpposite() || side == perpRotDir.getOpposite()) {
                    yield CamoGetter.FIRST;
                }
                if (side == dir.getOpposite() && (edge == rotDir.getOpposite() || edge == perpRotDir.getOpposite())) {
                    yield CamoGetter.FIRST;
                }
                if (side == rotDir) {
                    if (edge == dir || edge == perpRotDir.getOpposite()) {
                        yield CamoGetter.FIRST;
                    }
                    if (edge == perpRotDir) {
                        yield CamoGetter.SECOND;
                    }
                } else if (side == perpRotDir) {
                    if (edge == dir || edge == rotDir.getOpposite()) {
                        yield CamoGetter.FIRST;
                    }
                    if (edge == rotDir) {
                        yield CamoGetter.SECOND;
                    }
                }
                yield CamoGetter.NONE;
            }
            default -> throw new IllegalStateException("Unexpected type: " + String.valueOf(this.getBlockType()));
        };
    }

    @Override
    public SolidityCheck calculateSolidityCheck(BlockState state, Direction side) {
        return switch (this.getBlockType()) {
            case BlockType.FRAMED_EXT_DOUBLE_CORNER_SLOPE_PANEL_W -> {
                Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
                if (side == dir) {
                    yield SolidityCheck.FIRST;
                }
                HorizontalRotation rot = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
                Direction perpRotDir = rot.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(dir);
                if (side == dir.getOpposite() || side == rot.withFacing(dir) || side == perpRotDir) {
                    yield SolidityCheck.BOTH;
                }
                yield SolidityCheck.SECOND;
            }
            case BlockType.FRAMED_EXT_INNER_DOUBLE_CORNER_SLOPE_PANEL_W -> {
                Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
                HorizontalRotation rot = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
                Direction rotDir = rot.withFacing(dir);
                Direction perpRotDir = rot.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(dir);
                if (side == dir || side == rotDir.getOpposite() || side == perpRotDir.getOpposite()) {
                    yield SolidityCheck.FIRST;
                }
                if (side == dir.getOpposite() || side == rotDir || side == perpRotDir) {
                    yield SolidityCheck.BOTH;
                }
                yield SolidityCheck.NONE;
            }
            default -> throw new IllegalStateException("Unexpected type: " + String.valueOf(this.getBlockType()));
        };
    }

    @Override
    @Nullable
    public BlockState getItemModelSource() {
        return null;
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return ((IFramedBlock)this.nonWallBlock.value()).getJadeRenderState(state);
    }
}

