/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.corgilib.mixin;

import corgitaco.corgilib.client.StructureBoxEditor;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.StructureBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={StructureBlock.class})
public class MixinStructureBlock {
    @Inject(method={"useWithoutItem(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/phys/BlockHitResult;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="HEAD")}, cancellable=true)
    private void bindBox(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult, CallbackInfoReturnable<InteractionResult> cir) {
        BlockEntity blockEntity;
        if (player.getItemInHand(InteractionHand.MAIN_HAND).is(Items.GOLDEN_AXE) && (blockEntity = level.getBlockEntity(pos)) instanceof StructureBlockEntity) {
            StructureBlockEntity structureBlockEntity = (StructureBlockEntity)blockEntity;
            if (level.isClientSide) {
                StructureBoxEditor.structureBox = StructureBoxEditor.getStructureWorldBox(structureBlockEntity);
                StructureBoxEditor.structureBlockPos = structureBlockEntity.getBlockPos();
                StructureBoxEditor.structureOffset = structureBlockEntity.getStructurePos();
                player.displayClientMessage((Component)Component.literal((String)"Editing structure block."), true);
            }
            cir.setReturnValue((Object)InteractionResult.PASS);
        }
    }
}

