/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.charginggadgets.blocks.chargingstation;

import com.direwolf20.charginggadgets.blocks.BlockRegistry;
import com.direwolf20.charginggadgets.blocks.chargingstation.ChargingStationTile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class ChargingStationContainer
extends AbstractContainerMenu {
    private static final int SLOTS = 2;
    public final ContainerData data;
    public ItemStackHandler handler;
    private ChargingStationTile tile;

    public ChargingStationContainer(int windowId, Inventory playerInventory, FriendlyByteBuf extraData) {
        this((ChargingStationTile)playerInventory.player.level().getBlockEntity(extraData.readBlockPos()), (ContainerData)new SimpleContainerData(4), windowId, playerInventory, new ItemStackHandler(2));
    }

    public ChargingStationContainer(@Nullable ChargingStationTile tile, ContainerData chargingStationData, int windowId, Inventory playerInventory, ItemStackHandler handler) {
        super(BlockRegistry.CHARGING_STATION_CONTAINER.get(), windowId);
        this.handler = handler;
        this.tile = tile;
        this.data = chargingStationData;
        this.setup(playerInventory);
        this.addDataSlots(chargingStationData);
    }

    public void setup(Inventory inventory) {
        int row;
        this.addSlot((Slot)new RestrictedSlot((IItemHandler)this.handler, 0, 65, 43));
        this.addSlot((Slot)new RestrictedSlot((IItemHandler)this.handler, 1, 119, 43));
        for (row = 0; row < 9; ++row) {
            int x = 8 + row * 18;
            int y = 142;
            this.addSlot(new Slot((Container)inventory, row, x, y));
        }
        for (row = 1; row < 4; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = 8 + col * 18;
                int y = row * 18 + 66;
                this.addSlot(new Slot((Container)inventory, col + row * 9, x, y));
            }
        }
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack currentStack = slot.getItem();
            itemstack = currentStack.copy();
            if (index < 2 ? !this.moveItemStackTo(currentStack, 2, this.slots.size(), false) : !this.moveItemStackTo(currentStack, 0, 2, false)) {
                return ItemStack.EMPTY;
            }
            if (currentStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean stillValid(Player playerIn) {
        BlockPos pos = this.tile.getBlockPos();
        if (this.tile == null) return false;
        if (this.tile.isRemoved()) return false;
        Vec3 vec3 = new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        if (!(playerIn.distanceToSqr(vec3.add(0.5, 0.5, 0.5)) <= 64.0)) return false;
        return true;
    }

    public int getMaxPower() {
        return this.data.get(1) * 32;
    }

    public int getEnergy() {
        return this.data.get(0) * 32;
    }

    public int getMaxBurn() {
        return this.data.get(3);
    }

    public int getRemaining() {
        return this.data.get(2);
    }

    static class RestrictedSlot
    extends SlotItemHandler {
        public RestrictedSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean mayPlace(@Nonnull ItemStack stack) {
            if (this.getSlotIndex() == ChargingStationTile.Slots.CHARGE.getId()) {
                return stack.getCapability(Capabilities.EnergyStorage.ITEM) != null;
            }
            if (this.getSlotIndex() == ChargingStationTile.Slots.FUEL.getId()) {
                return stack.getBurnTime(RecipeType.SMELTING) != 0;
            }
            return super.mayPlace(stack);
        }
    }
}

