/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.init;

import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.client.Shaders;
import codechicken.enderstorage.client.gui.GuiEnderItemStorage;
import codechicken.enderstorage.client.render.entity.TankLayerRenderer;
import codechicken.enderstorage.client.render.tile.RenderTileEnderChest;
import codechicken.enderstorage.client.render.tile.RenderTileEnderTank;
import codechicken.enderstorage.config.EnderStorageConfig;
import codechicken.enderstorage.init.EnderStorageModContent;
import codechicken.enderstorage.manager.EnderStorageManager;
import codechicken.enderstorage.storage.EnderItemStorage;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;

public class ClientInit {
    private static final CrashLock LOCK = new CrashLock("Already Initialized.");

    public static void init(IEventBus modBus) {
        LOCK.lock();
        modBus.addListener(ClientInit::onRegisterRenderers);
        modBus.addListener(ClientInit::onAddRenderLayers);
        modBus.addListener(ClientInit::onRegisterMenuScreens);
        modBus.addListener(ClientInit::onClientSetupEvent);
        Shaders.init(modBus);
    }

    private static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)EnderStorageModContent.ENDER_CHEST_TILE.get()), RenderTileEnderChest::new);
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)EnderStorageModContent.ENDER_TANK_TILE.get()), RenderTileEnderTank::new);
    }

    private static void onAddRenderLayers(EntityRenderersEvent.AddLayers event) {
        if (!EnderStorageConfig.disableCreatorVisuals) {
            for (PlayerSkin.Model skin : event.getSkins()) {
                LivingEntityRenderer skinRenderer = (LivingEntityRenderer)event.getSkin(skin);
                assert (skinRenderer != null);
                skinRenderer.addLayer((RenderLayer)new TankLayerRenderer((RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)skinRenderer));
            }
        }
    }

    private static void onRegisterMenuScreens(RegisterMenuScreensEvent event) {
        event.register((MenuType)EnderStorageModContent.ENDER_ITEM_STORAGE.get(), GuiEnderItemStorage::new);
    }

    private static void onClientSetupEvent(FMLClientSetupEvent event) {
        event.enqueueWork(ClientInit::registerPredicates);
    }

    private static void registerPredicates() {
        ItemProperties.register((Item)((Item)EnderStorageModContent.ENDER_POUCH.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"enderstorage", (String)"owned"), (ItemPropertyFunction)((ClampedItemPropertyFunction)(pStack, pLevel, pEntity, pSeed) -> Frequency.readFromStack(pStack).hasOwner() ? 1.0f : 0.0f));
        ItemProperties.register((Item)((Item)EnderStorageModContent.ENDER_POUCH.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"enderstorage", (String)"open"), (ItemPropertyFunction)((ClampedItemPropertyFunction)(pStack, pLevel, pEntity, pSeed) -> EnderStorageManager.instance(true).getStorage(Frequency.readFromStack(pStack), EnderItemStorage.TYPE).openCount()));
        ItemProperties.register((Item)((Item)EnderStorageModContent.ENDER_POUCH.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"enderstorage", (String)"left"), (pStack, pLevel, pEntity, pSeed) -> Frequency.readFromStack(pStack).left().ordinal());
        ItemProperties.register((Item)((Item)EnderStorageModContent.ENDER_POUCH.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"enderstorage", (String)"middle"), (pStack, pLevel, pEntity, pSeed) -> Frequency.readFromStack(pStack).middle().ordinal());
        ItemProperties.register((Item)((Item)EnderStorageModContent.ENDER_POUCH.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"enderstorage", (String)"right"), (pStack, pLevel, pEntity, pSeed) -> Frequency.readFromStack(pStack).right().ordinal());
    }
}

