/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.disenchanting_table.client.gui.screens;

import forge.com.cursee.disenchanting_table.client.ClientConfig;
import forge.com.cursee.disenchanting_table.client.gui.screens.DisenchantingTableScreen;
import forge.com.cursee.disenchanting_table.core.ServerConfig;
import forge.com.cursee.disenchanting_table.core.util.ExperienceHelper;
import forge.com.cursee.disenchanting_table.core.world.inventory.DisenchantingMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.ItemCombinerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ItemCombinerMenu;

public class DisenchantingMenuScreen
extends ItemCombinerScreen<DisenchantingMenu> {
    public DisenchantingMenuScreen(DisenchantingMenu $$0, Inventory $$1, Component $$2) {
        super((ItemCombinerMenu)$$0, $$1, $$2, DisenchantingTableScreen.DISENCHANTING_TABLE_LOCATION);
    }

    protected void init() {
        super.init();
        this.titleLabelY += 9999;
        this.inventoryLabelY += 9999;
    }

    public void resize(Minecraft minecraft, int width, int height) {
        this.init(minecraft, width, height);
    }

    protected void renderErrorIcon(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTick, mouseX, mouseY);
        if (!((DisenchantingMenu)this.menu).hasResult()) {
            return;
        }
        Minecraft instance = Minecraft.getInstance();
        if (instance.player == null) {
            return;
        }
        LocalPlayer player = instance.player;
        boolean mayPickupResult = false;
        if (ServerConfig.uses_points && ExperienceHelper.getTotalPlayerExperiencePoints((Player)player) >= ServerConfig.experience_cost) {
            mayPickupResult = true;
        } else if (!ServerConfig.uses_points && player.experienceLevel >= ServerConfig.experience_cost) {
            mayPickupResult = true;
        }
        if (!ClientConfig.render_experience_cost || mayPickupResult || player.getAbilities().instabuild) {
            return;
        }
        guiGraphics.blit(DisenchantingTableScreen.DISENCHANTING_TABLE_LOCATION, this.leftPos + 102, this.topPos + 45, this.imageWidth, 0, 28, 21);
        int textPadding = 4;
        int xStart = this.leftPos + 45;
        int yStart = this.topPos + 72;
        MutableComponent text = Component.literal((String)"Insufficient Experience!");
        guiGraphics.fill(xStart, yStart, xStart + this.font.width((FormattedText)text) + 4, yStart + 11, -12242305);
        guiGraphics.drawString(this.font, (Component)text, xStart + 2, yStart + 2, -40864);
    }
}

