/*
 * Decompiled with CFR 0.152.
 */
package lyrellion.ars_elemancy.datagen;

import com.google.gson.JsonElement;
import com.hollingsworth.arsnouveau.api.familiar.AbstractFamiliarHolder;
import com.hollingsworth.arsnouveau.api.perk.IPerk;
import com.hollingsworth.arsnouveau.api.registry.PerkRegistry;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.common.crafting.recipes.EnchantingApparatusRecipe;
import com.hollingsworth.arsnouveau.common.datagen.ApparatusRecipeBuilder;
import com.hollingsworth.arsnouveau.common.datagen.PatchouliProvider;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.ApparatusPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.CraftingPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.EntityPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.GlyphScribePage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.IPatchouliPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.ImbuementPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.PatchouliBuilder;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.TextPage;
import com.hollingsworth.arsnouveau.common.items.PerkItem;
import java.util.concurrent.CompletableFuture;
import lyrellion.ars_elemancy.ArsNouveauRegistry;
import lyrellion.ars_elemancy.common.items.armor.ArmorSet;
import lyrellion.ars_elemancy.datagen.AEApparatusProvider;
import lyrellion.ars_elemancy.registry.ModItems;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;

public class AEPatchouliProvider
extends PatchouliProvider {
    public AEPatchouliProvider(DataGenerator generatorIn, CompletableFuture<HolderLookup.Provider> provider) {
        super(generatorIn, provider);
    }

    public void collectJsons(CachedOutput cache) {
        for (AbstractSpellPart spell : ArsNouveauRegistry.registeredSpells) {
            this.addGlyphPage(spell);
        }
        this.addBasicItem((ItemLike)ModItems.TEMPEST_BANGLE.get(), EQUIPMENT, (IPatchouliPage)new ApparatusPage((ItemLike)ModItems.TEMPEST_BANGLE.get()));
        this.addBasicItem((ItemLike)ModItems.MIRE_BANGLE.get(), EQUIPMENT, (IPatchouliPage)new ApparatusPage((ItemLike)ModItems.MIRE_BANGLE.get()));
        this.addBasicItem((ItemLike)ModItems.VAPOR_BANGLE.get(), EQUIPMENT, (IPatchouliPage)new ApparatusPage((ItemLike)ModItems.VAPOR_BANGLE.get()));
        this.addBasicItem((ItemLike)ModItems.SILT_BANGLE.get(), EQUIPMENT, (IPatchouliPage)new ApparatusPage((ItemLike)ModItems.SILT_BANGLE.get()));
        this.addBasicItem((ItemLike)ModItems.LAVA_BANGLE.get(), EQUIPMENT, (IPatchouliPage)new ApparatusPage((ItemLike)ModItems.LAVA_BANGLE.get()));
        this.addBasicItem((ItemLike)ModItems.CINDER_BANGLE.get(), EQUIPMENT, (IPatchouliPage)new ApparatusPage((ItemLike)ModItems.CINDER_BANGLE.get()));
        this.addBasicItem((ItemLike)ModItems.ELEMANCER_BANGLE.get(), EQUIPMENT, (IPatchouliPage)new ApparatusPage((ItemLike)ModItems.ELEMANCER_BANGLE.get()));
        this.addArmorPage(ModItems.TEMPEST_ARMOR);
        this.addArmorPage(ModItems.MIRE_ARMOR);
        this.addArmorPage(ModItems.SILT_ARMOR);
        this.addArmorPage(ModItems.LAVA_ARMOR);
        this.addArmorPage(ModItems.VAPOR_ARMOR);
        this.addArmorPage(ModItems.CINDER_ARMOR);
        this.addArmorPage(ModItems.ELEMANCER_ARMOR);
        for (PatchouliProvider.PatchouliPage patchouliPage : this.pages) {
            this.saveStable(cache, (JsonElement)patchouliPage.build(), patchouliPage.path());
        }
    }

    private void addArmorPage(ArmorSet armorSet) {
        PatchouliBuilder builder = new PatchouliBuilder(ARMOR, armorSet.getTranslationKey()).withIcon((ItemLike)armorSet.getHat()).withPage((IPatchouliPage)new TextPage("ars_elemancy.page.armor_set." + armorSet.getName()));
        for (Item piece : new Item[]{armorSet.getHat(), armorSet.getChest(), armorSet.getLegs(), armorSet.getBoots()}) {
            for (ApparatusRecipeBuilder.RecipeWrapper<? extends EnchantingApparatusRecipe> wrapper : AEApparatusProvider.RECIPES) {
                if (!wrapper.recipe().result().is(piece)) continue;
                builder = builder.withPage((IPatchouliPage)new AEPage(wrapper.id().toString()));
            }
        }
        this.pages.add(new PatchouliProvider.PatchouliPage(builder, this.getPath(ARMOR, "armor_" + armorSet.getName())));
    }

    public void addPerkPage(IPerk perk) {
        PerkItem perkItem = (PerkItem)PerkRegistry.getPerkItemMap().get(perk.getRegistryName());
        PatchouliBuilder builder = new PatchouliBuilder(ARMOR, (ItemLike)perkItem).withIcon((ItemLike)perkItem).withTextPage(perk.getDescriptionKey()).withPage((IPatchouliPage)new ApparatusPage((ItemLike)perkItem)).withSortNum(99);
        this.pages.add(new PatchouliProvider.PatchouliPage(builder, this.getPath(ARMOR, perk.getRegistryName().getPath() + ".json")));
    }

    public PatchouliProvider.PatchouliPage addBasicItem(ItemLike item, ResourceLocation category, IPatchouliPage recipePage) {
        PatchouliBuilder builder = new PatchouliBuilder(category, item.asItem().getDescriptionId()).withIcon((ItemLike)item.asItem()).withPage((IPatchouliPage)new TextPage("ars_elemancy.page." + this.getRegistryName(item.asItem()).getPath())).withPage(recipePage);
        PatchouliProvider.PatchouliPage page = new PatchouliProvider.PatchouliPage(builder, this.getPath(category, this.getRegistryName(item.asItem()).getPath()));
        this.pages.add(page);
        return page;
    }

    public void addFamiliarPage(AbstractFamiliarHolder familiarHolder) {
        PatchouliBuilder builder = new PatchouliBuilder(FAMILIARS, "entity.ars_elemancy." + familiarHolder.getRegistryName().getPath()).withIcon("ars_elemancy:" + familiarHolder.getRegistryName().getPath()).withTextPage("ars_elemancy.familiar_desc." + familiarHolder.getRegistryName().getPath()).withPage((IPatchouliPage)new EntityPage(familiarHolder.getRegistryName().toString()));
        this.pages.add(new PatchouliProvider.PatchouliPage(builder, this.getPath(FAMILIARS, familiarHolder.getRegistryName().getPath())));
    }

    public void addRitualPage(AbstractRitual ritual) {
        PatchouliBuilder builder = new PatchouliBuilder(RITUALS, "item.ars_elemancy." + ritual.getRegistryName().getPath()).withIcon(ritual.getRegistryName().toString()).withTextPage(ritual.getDescriptionKey()).withPage((IPatchouliPage)new CraftingPage("ars_elemancy:tablet_" + ritual.getRegistryName().getPath()));
        this.pages.add(new PatchouliProvider.PatchouliPage(builder, this.getPath(RITUALS, ritual.getRegistryName().getPath())));
    }

    public void addGlyphPage(AbstractSpellPart spellPart) {
        ResourceLocation category = switch (spellPart.defaultTier().value) {
            case 1 -> GLYPHS_1;
            case 2 -> GLYPHS_2;
            default -> GLYPHS_3;
        };
        PatchouliBuilder builder = new PatchouliBuilder(category, spellPart.getName()).withName("ars_elemancy.glyph_name." + spellPart.getRegistryName().getPath()).withIcon(spellPart.getRegistryName().toString()).withSortNum(spellPart instanceof AbstractCastMethod ? 1 : (spellPart instanceof AbstractEffect ? 2 : 3)).withPage((IPatchouliPage)new TextPage("ars_elemancy.glyph_desc." + spellPart.getRegistryName().getPath())).withPage((IPatchouliPage)new GlyphScribePage(spellPart));
        this.pages.add(new PatchouliProvider.PatchouliPage(builder, this.getPath(category, spellPart.getRegistryName().getPath())));
    }

    public String getName() {
        return "Ars Elemancy Patchouli Datagen";
    }

    ImbuementPage ImbuementPage(ItemLike item) {
        return new ImbuementPage("ars_elemancy:imbuement_" + this.getRegistryName(item.asItem()).getPath());
    }

    private ResourceLocation getRegistryName(Item asItem) {
        return BuiltInRegistries.ITEM.getKey((Object)asItem);
    }

    static class AEPage
    extends ApparatusPage {
        public AEPage(String recipe) {
            super(recipe);
        }

        public ResourceLocation getType() {
            return ResourceLocation.fromNamespaceAndPath((String)"ars_nouveau", (String)"elemancy_armor_recipe");
        }
    }
}

