/*
 * Decompiled with CFR 0.152.
 */
package lu.kolja.expandedae.datagen;

import appeng.api.util.AEColor;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.AEParts;
import com.glodblock.github.extendedae.common.EAESingletons;
import gripe._90.megacells.definition.MEGABlocks;
import gripe._90.megacells.definition.MEGAItems;
import java.util.concurrent.CompletableFuture;
import lu.kolja.expandedae.Expandedae;
import lu.kolja.expandedae.datagen.conditionals.ModNotLoadedCondition;
import lu.kolja.expandedae.definition.ExpBlocks;
import lu.kolja.expandedae.definition.ExpItems;
import lu.kolja.expandedae.enums.ExpTiers;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import org.jetbrains.annotations.NotNull;

public class ExpRecipeProvider
extends RecipeProvider {
    public ExpRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(@NotNull RecipeOutput out) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ExpBlocks.EXP_PATTERN_PROVIDER).pattern("ECE").pattern("CPC").pattern("ECE").define(Character.valueOf('C'), (ItemLike)AEItems.CAPACITY_CARD).define(Character.valueOf('E'), (ItemLike)AEItems.ENGINEERING_PROCESSOR).define(Character.valueOf('P'), (ItemLike)AEBlocks.PATTERN_PROVIDER).unlockedBy("has_engineering_processor", ExpRecipeProvider.has((ItemLike)AEItems.ENGINEERING_PROCESSOR)).unlockedBy("has_pattern_provider", ExpRecipeProvider.has((ItemLike)AEBlocks.PATTERN_PROVIDER)).save(ExpRecipeProvider.conditional(out, ExpRecipeProvider.notLoaded("extendedae")), this.craftingId("exp_pattern_provider_ae"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ExpBlocks.EXP_PATTERN_PROVIDER).pattern("CE").pattern("EC").define(Character.valueOf('E'), (ItemLike)EAESingletons.EX_PATTERN_PROVIDER).define(Character.valueOf('C'), (ItemLike)EAESingletons.CONCURRENT_PROCESSOR).unlockedBy("has_concurrent_processor", ExpRecipeProvider.has((ItemLike)EAESingletons.CONCURRENT_PROCESSOR)).save(ExpRecipeProvider.conditional(out, ExpRecipeProvider.loaded("extendedae")), this.craftingId("exp_pattern_provider_ext"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, ExpBlocks.EXP_PATTERN_PROVIDER).requires(ExpItems.EXP_PATTERN_PROVIDER_PART).unlockedBy("has_exp_pattern_provider_part", ExpRecipeProvider.has(ExpItems.EXP_PATTERN_PROVIDER_PART)).save(out, this.craftingId("exp_pattern_provider_alt"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, ExpItems.EXP_PATTERN_PROVIDER_PART).requires(ExpBlocks.EXP_PATTERN_PROVIDER).unlockedBy("has_exp_pattern_provider", ExpRecipeProvider.has(ExpBlocks.EXP_PATTERN_PROVIDER)).save(out, this.craftingId("exp_pattern_provider_part"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ExpItems.EXP_PATTERN_PROVIDER_UPGRADE).pattern("ECE").pattern("C C").pattern("ECE").define(Character.valueOf('C'), (ItemLike)AEItems.CAPACITY_CARD).define(Character.valueOf('E'), (ItemLike)AEItems.ENGINEERING_PROCESSOR).unlockedBy("has_engineering_processor", ExpRecipeProvider.has((ItemLike)AEItems.ENGINEERING_PROCESSOR)).unlockedBy("has_capacity_card", ExpRecipeProvider.has((ItemLike)AEItems.CAPACITY_CARD)).save(ExpRecipeProvider.conditional(out, ExpRecipeProvider.notLoaded("extendedae")), this.craftingId("exp_pattern_provider_upgrade_ae"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ExpItems.EXP_PATTERN_PROVIDER_UPGRADE).pattern("CE").pattern("E ").define(Character.valueOf('E'), (ItemLike)EAESingletons.EX_PATTERN_PROVIDER).define(Character.valueOf('C'), (ItemLike)EAESingletons.CONCURRENT_PROCESSOR).unlockedBy("has_concurrent_processor", ExpRecipeProvider.has((ItemLike)EAESingletons.CONCURRENT_PROCESSOR)).unlockedBy("has_exp_pattern_provider", ExpRecipeProvider.has((ItemLike)EAESingletons.EX_PATTERN_PROVIDER)).save(ExpRecipeProvider.conditional(out, ExpRecipeProvider.loaded("extendedae")), this.craftingId("exp_pattern_provider_upgrade_ext"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, ExpItems.AUTO_COMPLETE_CARD).requires((ItemLike)AEItems.ADVANCED_CARD).requires((ItemLike)AEItems.CRAFTING_CARD).unlockedBy("has_advanced_card", ExpRecipeProvider.has((ItemLike)AEItems.ADVANCED_CARD)).unlockedBy("has_crafting_card", ExpRecipeProvider.has((ItemLike)AEItems.CRAFTING_CARD)).save(out, this.craftingId("auto_complete_card"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ExpItems.PATTERN_REFILLER_CARD).pattern("AB").pattern("BE").define(Character.valueOf('A'), (ItemLike)AEItems.ADVANCED_CARD).define(Character.valueOf('B'), (ItemLike)AEItems.BLANK_PATTERN).define(Character.valueOf('E'), (ItemLike)AEItems.ENGINEERING_PROCESSOR).unlockedBy("has_advanced_card", ExpRecipeProvider.has((ItemLike)AEItems.ADVANCED_CARD)).unlockedBy("has_engineering_processor", ExpRecipeProvider.has((ItemLike)AEItems.ENGINEERING_PROCESSOR)).save(out, this.craftingId("pattern_refiller_card"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ExpItems.EXP_ENCODING_TERMINAL).pattern("TC").pattern("L ").define(Character.valueOf('T'), (ItemLike)AEParts.PATTERN_ENCODING_TERMINAL).define(Character.valueOf('C'), (ItemLike)AEItems.CALCULATION_PROCESSOR).define(Character.valueOf('L'), (ItemLike)AEItems.LOGIC_PROCESSOR).unlockedBy("has_calculation_processor", ExpRecipeProvider.has((ItemLike)AEItems.CALCULATION_PROCESSOR)).unlockedBy("has_logic_processor", ExpRecipeProvider.has((ItemLike)AEItems.LOGIC_PROCESSOR)).save(out, this.craftingId("exp_encoding_terminal"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ExpBlocks.EXP_IO_PORT).pattern("AAA").pattern("AIA").pattern("AAA").define(Character.valueOf('A'), ExpItems.GREATER_ACCEL_CARD).define(Character.valueOf('I'), (ItemLike)AEBlocks.IO_PORT).unlockedBy("has_speed_card", ExpRecipeProvider.has(ExpItems.GREATER_ACCEL_CARD)).save(ExpRecipeProvider.conditional(out, ExpRecipeProvider.notLoaded("extendedae")), this.craftingId("exp_io_port_ae"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ExpBlocks.EXP_IO_PORT).pattern("AAA").pattern("AIA").pattern("AAA").define(Character.valueOf('A'), ExpItems.GREATER_ACCEL_CARD).define(Character.valueOf('I'), (ItemLike)EAESingletons.EX_IO_PORT).unlockedBy("has_speed_card", ExpRecipeProvider.has(ExpItems.GREATER_ACCEL_CARD)).save(ExpRecipeProvider.conditional(out, ExpRecipeProvider.loaded("extendedae")), this.craftingId("exp_io_port_ext"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ExpItems.GREATER_ACCEL_CARD).pattern("AAA").pattern("ACA").pattern("AAA").define(Character.valueOf('A'), (ItemLike)AEItems.SPEED_CARD).define(Character.valueOf('C'), (ItemLike)AEItems.CALCULATION_PROCESSOR).unlockedBy("has_speed_card", ExpRecipeProvider.has((ItemLike)AEItems.SPEED_CARD)).unlockedBy("has_calculation_processor", ExpRecipeProvider.has((ItemLike)AEItems.CALCULATION_PROCESSOR)).save(out, this.craftingId("greater_accel_card"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ExpBlocks.UNIT).pattern("UPU").pattern("CLC").pattern("UPU").define(Character.valueOf('U'), (ItemLike)AEBlocks.CRAFTING_UNIT).define(Character.valueOf('P'), (ItemLike)AEItems.ENGINEERING_PROCESSOR).define(Character.valueOf('C'), (ItemLike)AEParts.SMART_DENSE_CABLE.item(AEColor.TRANSPARENT)).define(Character.valueOf('L'), (ItemLike)AEItems.LOGIC_PROCESSOR).unlockedBy("has_engineering_processor", ExpRecipeProvider.has((ItemLike)AEItems.ENGINEERING_PROCESSOR)).unlockedBy("has_logic_processor", ExpRecipeProvider.has((ItemLike)AEItems.LOGIC_PROCESSOR)).save(ExpRecipeProvider.conditional(out, ExpRecipeProvider.notLoaded("megacells")), this.craftingId("exp_crafting_unit_ae"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ExpBlocks.UNIT).pattern("UPU").pattern("CLC").pattern("UPU").define(Character.valueOf('U'), (ItemLike)MEGABlocks.MEGA_CRAFTING_UNIT).define(Character.valueOf('P'), (ItemLike)AEItems.ENGINEERING_PROCESSOR).define(Character.valueOf('C'), (ItemLike)AEParts.SMART_DENSE_CABLE.item(AEColor.TRANSPARENT)).define(Character.valueOf('L'), (ItemLike)MEGAItems.ACCUMULATION_PROCESSOR).unlockedBy("has_engineering_processor", ExpRecipeProvider.has((ItemLike)AEItems.ENGINEERING_PROCESSOR)).unlockedBy("has_logic_processor", ExpRecipeProvider.has((ItemLike)MEGAItems.ACCUMULATION_PROCESSOR)).save(ExpRecipeProvider.conditional(out, ExpRecipeProvider.loaded("megacells")), this.craftingId("exp_crafting_unit_mega"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, ExpTiers.TIER_2.getDefinition()).requires(ExpBlocks.UNIT).requires((ItemLike)AEItems.ENGINEERING_PROCESSOR).unlockedBy("has_engineering_processor", ExpRecipeProvider.has((ItemLike)AEItems.ENGINEERING_PROCESSOR)).save(out, this.craftingId("exp_crafting_accelerator_2"));
        this.upgrade(out, ExpTiers.TIER_2, ExpTiers.TIER_4);
        this.upgrade(out, ExpTiers.TIER_4, ExpTiers.TIER_8);
        this.upgrade(out, ExpTiers.TIER_8, ExpTiers.TIER_16);
        this.upgrade(out, ExpTiers.TIER_16, ExpTiers.TIER_32);
        this.upgrade(out, ExpTiers.TIER_32, ExpTiers.TIER_64);
        this.upgrade(out, ExpTiers.TIER_64, ExpTiers.TIER_128);
        this.upgrade(out, ExpTiers.TIER_128, ExpTiers.TIER_256);
        this.upgrade(out, ExpTiers.TIER_256, ExpTiers.TIER_512);
        this.upgrade(out, ExpTiers.TIER_512, ExpTiers.TIER_1K);
        this.upgrade(out, ExpTiers.TIER_1K, ExpTiers.TIER_2K);
        this.upgrade(out, ExpTiers.TIER_2K, ExpTiers.TIER_4K);
        this.upgrade(out, ExpTiers.TIER_4K, ExpTiers.TIER_8K);
        this.upgrade(out, ExpTiers.TIER_8K, ExpTiers.TIER_16K);
        this.upgrade(out, ExpTiers.TIER_16K, ExpTiers.TIER_32K);
        this.upgrade(out, ExpTiers.TIER_32K, ExpTiers.TIER_64K);
        this.upgrade(out, ExpTiers.TIER_64K, ExpTiers.TIER_128K);
        this.upgrade(out, ExpTiers.TIER_128K, ExpTiers.TIER_256K);
        this.upgrade(out, ExpTiers.TIER_256K, ExpTiers.TIER_512K);
        this.upgrade(out, ExpTiers.TIER_512K, ExpTiers.TIER_1M);
    }

    private ResourceLocation craftingId(String name) {
        return Expandedae.makeId("crafting/" + name);
    }

    private void upgrade(RecipeOutput out, ExpTiers previousTier, ExpTiers tier) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, tier.getDefinition()).requires(previousTier.getDefinition(), 2).unlockedBy("has_calculation_processor", ExpRecipeProvider.has((ItemLike)AEItems.CALCULATION_PROCESSOR)).save(out, this.craftingId(tier.getCpuAffix()));
    }

    private static RecipeOutput conditional(RecipeOutput output, ICondition ... condition) {
        return output.withConditions(condition);
    }

    private static ICondition loaded(String mod) {
        return new ModLoadedCondition(mod);
    }

    private static ICondition notLoaded(String mod) {
        return new ModNotLoadedCondition(mod);
    }
}

