/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.impl;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Function;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import noobanidus.mods.lootr.common.api.ILootrAPI;
import noobanidus.mods.lootr.common.api.ILootrBlockEntityConverter;
import noobanidus.mods.lootr.common.api.ILootrEntityConverter;
import noobanidus.mods.lootr.common.api.data.blockentity.ILootrBlockEntity;
import noobanidus.mods.lootr.common.api.data.entity.ILootrCart;
import noobanidus.mods.lootr.common.api.filter.ILootrFilter;
import noobanidus.mods.lootr.common.api.filter.ILootrFilterProvider;
import noobanidus.mods.lootr.common.api.processor.ILootrPostProcessor;
import noobanidus.mods.lootr.common.api.processor.ILootrPreProcessor;
import org.jetbrains.annotations.Nullable;

public class LootrServiceRegistry {
    private static LootrServiceRegistry INSTANCE;
    private final Map<BlockEntityType<?>, Function<?, ?>> blockEntityConverterMap = new Object2ObjectOpenHashMap();
    private final Map<EntityType<?>, Function<?, ?>> entityConverterMap = new Object2ObjectOpenHashMap();
    private final List<ILootrFilter> filters = new ObjectArrayList();
    private final List<ILootrPostProcessor> postProcessors = new ObjectArrayList();
    private final List<ILootrPreProcessor> preProcessors = new ObjectArrayList();

    public LootrServiceRegistry() {
        ClassLoader classLoader = ILootrAPI.class.getClassLoader();
        ServiceLoader<ILootrBlockEntityConverter> loader = ServiceLoader.load(ILootrBlockEntityConverter.class, classLoader);
        for (ILootrBlockEntityConverter iLootrBlockEntityConverter : loader) {
            this.blockEntityConverterMap.put(iLootrBlockEntityConverter.getBlockEntityType(), iLootrBlockEntityConverter);
        }
        ServiceLoader<ILootrEntityConverter> loader2 = ServiceLoader.load(ILootrEntityConverter.class, classLoader);
        for (ILootrEntityConverter iLootrEntityConverter : loader2) {
            this.entityConverterMap.put(iLootrEntityConverter.getEntityType(), iLootrEntityConverter);
        }
        ServiceLoader<ILootrFilterProvider> serviceLoader = ServiceLoader.load(ILootrFilterProvider.class, classLoader);
        for (ILootrFilterProvider iLootrFilterProvider : serviceLoader) {
            this.filters.addAll(iLootrFilterProvider.getFilters());
        }
        this.filters.sort(Comparator.comparingInt(ILootrFilter::getPriority));
        ServiceLoader<ILootrPostProcessor> serviceLoader2 = ServiceLoader.load(ILootrPostProcessor.class, classLoader);
        for (ILootrPostProcessor processor : serviceLoader2) {
            this.postProcessors.add(processor);
        }
        ServiceLoader<ILootrPreProcessor> serviceLoader3 = ServiceLoader.load(ILootrPreProcessor.class, classLoader);
        for (ILootrPreProcessor processor : serviceLoader3) {
            this.preProcessors.add(processor);
        }
    }

    public static LootrServiceRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LootrServiceRegistry();
        }
        return INSTANCE;
    }

    @Nullable
    private static <T> Function<T, ILootrBlockEntity> getBlockEntity(BlockEntityType<?> clazz) {
        return LootrServiceRegistry.getInstance().blockEntityConverterMap.get(clazz);
    }

    @Nullable
    private static <T> Function<T, ILootrCart> getEntity(EntityType<?> clazz) {
        return LootrServiceRegistry.getInstance().entityConverterMap.get(clazz);
    }

    @Nullable
    static <T extends BlockEntity> ILootrBlockEntity convertBlockEntity(T blockEntity) {
        if (blockEntity == null) {
            return null;
        }
        Function<T, ILootrBlockEntity> converter = LootrServiceRegistry.getBlockEntity(blockEntity.getType());
        if (converter == null) {
            return null;
        }
        return converter.apply(blockEntity);
    }

    @Nullable
    static <T extends Entity> ILootrCart convertEntity(T entity) {
        if (entity == null) {
            return null;
        }
        Function<T, ILootrCart> converter = LootrServiceRegistry.getEntity(entity.getType());
        if (converter == null) {
            return null;
        }
        return converter.apply(entity);
    }

    static List<ILootrFilter> getFilters() {
        return LootrServiceRegistry.getInstance().filters;
    }

    static List<ILootrPreProcessor> getPreProcessors() {
        return LootrServiceRegistry.getInstance().preProcessors;
    }

    static List<ILootrPostProcessor> getPostProcessors() {
        return LootrServiceRegistry.getInstance().postProcessors;
    }
}

