/*
 * Decompiled with CFR 0.152.
 */
package artifacts.neoforge;

import artifacts.Artifacts;
import artifacts.ArtifactsClient;
import artifacts.client.CooldownOverlayRenderer;
import artifacts.client.item.ArtifactRenderers;
import artifacts.client.mimic.MimicRenderer;
import artifacts.neoforge.client.ArmRenderHandler;
import artifacts.neoforge.client.HeliumFlamingoOverlayRenderer;
import artifacts.neoforge.client.UmbrellaArmPoseHandler;
import artifacts.neoforge.integration.curios.CuriosCompatClient;
import artifacts.platform.PlatformServices;
import artifacts.registry.ModEntityTypes;
import artifacts.registry.ModItems;
import artifacts.registry.ModKeyMappings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.logging.log4j.util.TriConsumer;

public class ArtifactsNeoForgeClient {
    public ArtifactsNeoForgeClient(IEventBus modBus) {
        ArtifactsClient.setup();
        modBus.addListener(this::onClientSetup);
        modBus.addListener(this::registerGuiLayers);
        modBus.addListener(this::registerLayerDefinitions);
        modBus.addListener(this::registerEntityRenderers);
        modBus.addListener(event -> ModKeyMappings.register(arg_0 -> ((RegisterKeyMappingsEvent)event).register(arg_0)));
        boolean isCuriosLoaded = PlatformServices.platformHelper.isModLoaded("curios");
        boolean isTrinketsLoaded = PlatformServices.platformHelper.isModLoaded("trinkets");
        if (isCuriosLoaded || isTrinketsLoaded) {
            ArmRenderHandler.setup();
        }
        if (isCuriosLoaded) {
            CuriosCompatClient.setup(modBus);
        }
        NeoForge.EVENT_BUS.addListener(event -> ArtifactsClient.onClientTick(Minecraft.getInstance()));
    }

    public void onClientSetup(FMLClientSetupEvent event) {
        UmbrellaArmPoseHandler.setup();
        event.enqueueWork(() -> {
            ItemProperties.register((Item)((Item)ModItems.UMBRELLA.value()), (ResourceLocation)Artifacts.id("blocking"), (stack, level, entity, seed) -> entity != null && entity.isUsingItem() && entity.getUseItem() == stack ? 1.0f : 0.0f);
            ArtifactsClient.registerItemPropertyFunctions((TriConsumer<Item, ResourceLocation, ClampedItemPropertyFunction>)((TriConsumer)(item, id, f) -> ItemProperties.register((Item)item, (ResourceLocation)id, (ItemPropertyFunction)f)));
            ArtifactRenderers.register();
            ArtifactsClient.onClientStarted();
        });
    }

    public void registerGuiLayers(RegisterGuiLayersEvent event) {
        event.registerAbove(VanillaGuiLayers.AIR_LEVEL, Artifacts.id("helium_flamingo_charge"), HeliumFlamingoOverlayRenderer::render);
        event.registerAbove(VanillaGuiLayers.HOTBAR, Artifacts.id("artifact_cooldowns"), CooldownOverlayRenderer::render);
    }

    public void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        ArtifactsClient.registerLayerDefinitions((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterLayerDefinitions)event).registerLayerDefinition(arg_0, arg_1));
    }

    public void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(ModEntityTypes.MIMIC.get(), MimicRenderer::new);
    }
}

