/*
 * Decompiled with CFR 0.152.
 */
package artifacts.neoforge.data;

import artifacts.Artifacts;
import artifacts.registry.ModSoundEvents;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.data.SoundDefinition;
import net.neoforged.neoforge.common.data.SoundDefinitionsProvider;

public class SoundDefinitions
extends SoundDefinitionsProvider {
    public SoundDefinitions(PackOutput output, ExistingFileHelper helper) {
        super(output, "artifacts", helper);
    }

    public void registerSounds() {
        this.addSubtitled((SoundEvent)ModSoundEvents.MIMIC_OPEN.value()).with(SoundDefinitions.sound(SoundEvents.CHEST_OPEN));
        this.addSubtitled((SoundEvent)ModSoundEvents.MIMIC_CLOSE.value()).with(SoundDefinitions.sound(SoundEvents.CHEST_CLOSE));
        this.addSubtitled((SoundEvent)ModSoundEvents.MIMIC_HURT.value()).with(SoundDefinitions.sounds("mimic/hurt", 3));
        this.addSubtitled((SoundEvent)ModSoundEvents.MIMIC_DEATH.value()).with(SoundDefinitions.sounds("mimic/death", 2));
        this.add((SoundEvent)ModSoundEvents.WATER_STEP.value()).with(SoundDefinitions.sound(SoundEvents.COD_FLOP)).subtitle("subtitles.block.generic.footsteps");
        this.addSubtitled((SoundEvent)ModSoundEvents.FART.value()).with(SoundDefinitions.sounds("fart", 2));
        this.add((SoundEvent)ModSoundEvents.POP.value()).with(SoundDefinitions.sound((ResourceLocation)ResourceLocation.parse((String)"random/pop")).pitch(0.75).volume(0.5));
    }

    protected static SoundDefinition.Sound sound(SoundEvent soundEvent) {
        return SoundDefinitions.sound((ResourceLocation)soundEvent.getLocation(), (SoundDefinition.SoundType)SoundDefinition.SoundType.EVENT);
    }

    protected static SoundDefinition.Sound sound(String path) {
        return SoundDefinitions.sound((ResourceLocation)Artifacts.id(path));
    }

    protected static SoundDefinition.Sound[] sounds(String path, int count) {
        SoundDefinition.Sound[] result = new SoundDefinition.Sound[count];
        for (int i = 0; i < count; ++i) {
            result[i] = SoundDefinitions.sound(path + (i + 1));
        }
        return result;
    }

    private SoundDefinition add(SoundEvent soundEvent) {
        SoundDefinition result = SoundDefinitions.definition();
        this.add(soundEvent, result);
        return result;
    }

    private SoundDefinition addSubtitled(SoundEvent soundEvent) {
        return this.add(soundEvent).subtitle("%s.subtitles.%s".formatted("artifacts", soundEvent.getLocation().getPath()));
    }
}

