/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.crafting.ActuallyRecipes;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class LaserRecipe
implements Recipe<RecipeInput> {
    public static String NAME = "laser";
    private ItemStack result;
    private Ingredient itemIngredient;
    private int energy;

    public LaserRecipe(ItemStack result, Ingredient itemIngredient, int energy) {
        this.result = result;
        this.itemIngredient = itemIngredient;
        this.energy = energy;
    }

    public int getEnergy() {
        return this.energy;
    }

    public boolean matches(ItemStack itemStack, int energyIn) {
        return this.itemIngredient.test(itemStack) && energyIn >= this.energy;
    }

    public boolean matches(ItemStack itemStack) {
        return this.itemIngredient.test(itemStack);
    }

    public Ingredient getInput() {
        return this.itemIngredient;
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)ActuallyBlocks.ATOMIC_RECONSTRUCTOR.get());
    }

    public boolean matches(RecipeInput pInv, Level pLevel) {
        return false;
    }

    public boolean isSpecial() {
        return true;
    }

    public ItemStack assemble(RecipeInput pInv, HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.result;
    }

    public RecipeSerializer<?> getSerializer() {
        return ActuallyRecipes.LASER_RECIPE.get();
    }

    public RecipeType<?> getType() {
        return ActuallyRecipes.Types.LASER.get();
    }

    public static Optional<RecipeHolder<LaserRecipe>> getRecipeForStack(ItemStack stack) {
        return ActuallyAdditionsAPI.CONVERSION_LASER_RECIPES.stream().filter(recipe -> ((LaserRecipe)recipe.value()).matches(stack)).findFirst();
    }

    public boolean validInput(ItemStack stack) {
        return LaserRecipe.getRecipeForStack(stack).isPresent();
    }

    public static class Serializer
    implements RecipeSerializer<LaserRecipe> {
        private static final MapCodec<LaserRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.STRICT_SINGLE_ITEM_CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(recipe -> recipe.itemIngredient), (App)Codec.INT.fieldOf("energy").forGetter(recipe -> recipe.energy)).apply((Applicative)instance, LaserRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, LaserRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<LaserRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, LaserRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static LaserRecipe fromNetwork(@Nonnull RegistryFriendlyByteBuf pBuffer) {
            Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)pBuffer);
            int energy = pBuffer.readInt();
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)pBuffer);
            return new LaserRecipe(result, ingredient, energy);
        }

        public static void toNetwork(@Nonnull RegistryFriendlyByteBuf pBuffer, LaserRecipe pRecipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.itemIngredient);
            pBuffer.writeInt(pRecipe.energy);
            ItemStack.STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.result);
        }
    }
}

