/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.misc.apiimpl;

import de.ellpeck.actuallyadditions.api.laser.IConnectionPair;
import de.ellpeck.actuallyadditions.api.laser.ILaserRelayConnectionHandler;
import de.ellpeck.actuallyadditions.api.laser.LaserType;
import de.ellpeck.actuallyadditions.api.laser.Network;
import de.ellpeck.actuallyadditions.mod.data.WorldData;
import de.ellpeck.actuallyadditions.mod.misc.apiimpl.ConnectionPair;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelay;
import io.netty.util.internal.ConcurrentSet;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public final class LaserRelayConnectionHandler
implements ILaserRelayConnectionHandler {
    public static CompoundTag writeNetworkToNBT(Network network) {
        ListTag list = new ListTag();
        for (IConnectionPair pair : network.connections) {
            CompoundTag tag = new CompoundTag();
            pair.writeToNBT(tag);
            list.add((Object)tag);
        }
        CompoundTag compound = new CompoundTag();
        compound.put("Network", (Tag)list);
        return compound;
    }

    public static Network readNetworkFromNBT(CompoundTag tag) {
        ListTag list = tag.getList("Network", 10);
        Network network = new Network();
        for (int i = 0; i < list.size(); ++i) {
            ConnectionPair pair = new ConnectionPair();
            pair.readFromNBT(list.getCompound(i));
            network.connections.add((Object)pair);
        }
        return network;
    }

    private static void mergeNetworks(Network firstNetwork, Network secondNetwork, Level world) {
        for (IConnectionPair secondPair : secondNetwork.connections) {
            firstNetwork.connections.add((Object)secondPair);
        }
        WorldData data = WorldData.get(world);
        ++secondNetwork.changeAmount;
        data.laserRelayNetworks.remove((Object)secondNetwork);
        data.setDirty();
    }

    @Override
    public ConcurrentSet<IConnectionPair> getConnectionsFor(BlockPos relay, Level world) {
        ConcurrentSet allPairs = new ConcurrentSet();
        if (!world.isClientSide) {
            for (Network aNetwork : WorldData.get((Level)world).laserRelayNetworks) {
                for (IConnectionPair pair : aNetwork.connections) {
                    if (!pair.contains(relay)) continue;
                    allPairs.add((Object)pair);
                }
            }
        }
        return allPairs;
    }

    @Override
    public void removeRelayFromNetwork(BlockPos relay, Level world) {
        Network network = this.getNetworkFor(relay, world);
        if (network != null) {
            ++network.changeAmount;
            WorldData data = WorldData.get(world);
            data.laserRelayNetworks.remove((Object)network);
            data.setDirty();
            for (IConnectionPair pair : network.connections) {
                if (pair.contains(relay)) continue;
                this.addConnection(pair.getPositions()[0], pair.getPositions()[1], pair.getType(), world, pair.doesSuppressRender());
            }
        }
    }

    @Override
    public Network getNetworkFor(BlockPos relay, Level world) {
        if (world != null && !world.isClientSide) {
            for (Network aNetwork : WorldData.get((Level)world).laserRelayNetworks) {
                for (IConnectionPair pair : aNetwork.connections) {
                    if (!pair.contains(relay)) continue;
                    return aNetwork;
                }
            }
        }
        return null;
    }

    @Override
    public boolean addConnection(BlockPos firstRelay, BlockPos secondRelay, LaserType type, Level world) {
        return this.addConnection(firstRelay, secondRelay, type, world, false);
    }

    @Override
    public boolean addConnection(BlockPos firstRelay, BlockPos secondRelay, LaserType type, Level world, boolean suppressConnectionRender) {
        return this.addConnection(firstRelay, secondRelay, type, world, suppressConnectionRender, false);
    }

    @Override
    public boolean addConnection(BlockPos firstRelay, BlockPos secondRelay, LaserType type, Level world, boolean suppressConnectionRender, boolean removeIfConnected) {
        if (world.isClientSide || firstRelay == null || secondRelay == null || firstRelay == secondRelay || firstRelay.equals((Object)secondRelay)) {
            return false;
        }
        WorldData data = WorldData.get(world);
        Network firstNetwork = this.getNetworkFor(firstRelay, world);
        Network secondNetwork = this.getNetworkFor(secondRelay, world);
        if (firstNetwork == null && secondNetwork == null) {
            firstNetwork = new Network();
            data.laserRelayNetworks.add((Object)firstNetwork);
            firstNetwork.connections.add((Object)new ConnectionPair(firstRelay, secondRelay, type, suppressConnectionRender));
            ++firstNetwork.changeAmount;
        } else {
            if (firstNetwork == secondNetwork) {
                if (removeIfConnected) {
                    this.removeConnection(world, firstRelay, secondRelay);
                    return true;
                }
                return false;
            }
            if (firstNetwork != null && secondNetwork != null) {
                LaserRelayConnectionHandler.mergeNetworks(firstNetwork, secondNetwork, world);
                firstNetwork.connections.add((Object)new ConnectionPair(firstRelay, secondRelay, type, suppressConnectionRender));
                ++firstNetwork.changeAmount;
            } else if (firstNetwork != null) {
                firstNetwork.connections.add((Object)new ConnectionPair(firstRelay, secondRelay, type, suppressConnectionRender));
                ++firstNetwork.changeAmount;
            } else {
                secondNetwork.connections.add((Object)new ConnectionPair(firstRelay, secondRelay, type, suppressConnectionRender));
                ++secondNetwork.changeAmount;
            }
        }
        data.setDirty();
        return true;
    }

    @Override
    public void removeConnection(Level world, BlockPos firstRelay, BlockPos secondRelay) {
        Network network;
        if (world != null && !world.isClientSide && firstRelay != null && secondRelay != null && (network = this.getNetworkFor(firstRelay, world)) != null) {
            ++network.changeAmount;
            WorldData data = WorldData.get(world);
            data.laserRelayNetworks.remove((Object)network);
            data.setDirty();
            for (IConnectionPair pair : network.connections) {
                if (pair.contains(firstRelay) && pair.contains(secondRelay)) continue;
                this.addConnection(pair.getPositions()[0], pair.getPositions()[1], pair.getType(), world, pair.doesSuppressRender());
            }
        }
    }

    @Override
    public LaserType getTypeFromLaser(BlockEntity tile) {
        if (tile instanceof TileEntityLaserRelay) {
            return ((TileEntityLaserRelay)tile).type;
        }
        return null;
    }

    @Override
    public LaserType getTypeFromLaser(BlockPos pos, Level world) {
        return this.getTypeFromLaser(world.getBlockEntity(pos));
    }
}

