/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.compat.jade;

import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.entity.EntityMultipartPart;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.impl.ui.ArmorElement;
import snownee.jade.impl.ui.HealthElement;

public final class MultipartComponentProvider
extends Enum<MultipartComponentProvider>
implements IEntityComponentProvider {
    public static final /* enum */ MultipartComponentProvider INSTANCE = new MultipartComponentProvider();
    private static final /* synthetic */ MultipartComponentProvider[] $VALUES;

    public static MultipartComponentProvider[] values() {
        return (MultipartComponentProvider[])$VALUES.clone();
    }

    public static MultipartComponentProvider valueOf(String name) {
        return Enum.valueOf(MultipartComponentProvider.class, name);
    }

    public ResourceLocation getUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"multipart");
    }

    public void appendTooltip(ITooltip iTooltip, EntityAccessor entityAccessor, IPluginConfig iPluginConfig) {
        Entity entity = entityAccessor.getEntity();
        if (entity instanceof EntityMultipartPart) {
            EntityMultipartPart multipart = (EntityMultipartPart)entity;
            assert (Minecraft.getInstance().level != null);
            Entity parent = (Entity)Minecraft.getInstance().level.entityStorage.getEntityGetter().get(multipart.getParentId());
            if (parent instanceof Mob) {
                Mob mob = (Mob)parent;
                iTooltip.clear();
                iTooltip.addAll(mob.getDisplayName().toFlatList(Style.EMPTY.withColor(ChatFormatting.WHITE)));
                iTooltip.add((IElement)new HealthElement(mob.getMaxHealth(), mob.getHealth()));
                iTooltip.add((IElement)new ArmorElement((float)mob.getArmorValue()));
                if (mob instanceof EntityDragonBase) {
                    EntityDragonBase dragon = (EntityDragonBase)mob;
                    iTooltip.add((Component)Component.translatable((String)"dragon.stage").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)(" " + dragon.getDragonStage()))));
                    iTooltip.add((Component)Component.literal((String)(dragon.getAgeInDays() + "d")));
                    iTooltip.add((Component)Component.literal((String)(dragon.isMale() ? "Male" : "Female")));
                }
            }
        }
    }

    private static /* synthetic */ MultipartComponentProvider[] $values() {
        return new MultipartComponentProvider[]{INSTANCE};
    }

    static {
        $VALUES = MultipartComponentProvider.$values();
    }
}

