/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.data;

import com.google.common.collect.ImmutableList;
import com.iafenvoy.iceandfire.item.ItemDragonArmor;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class DragonArmorMaterial {
    private static final List<DragonArmorMaterial> MATERIALS = new ArrayList<DragonArmorMaterial>();
    public static final DragonArmorMaterial IRON = new DragonArmorMaterial("iron", 1.5);
    public static final DragonArmorMaterial COPPER = new DragonArmorMaterial("copper", 2.0);
    public static final DragonArmorMaterial SILVER = new DragonArmorMaterial("silver", 3.0);
    public static final DragonArmorMaterial GOLD = new DragonArmorMaterial("gold", 2.0);
    public static final DragonArmorMaterial DIAMOND = new DragonArmorMaterial("diamond", 5.0);
    public static final DragonArmorMaterial NETHERITE = new DragonArmorMaterial("netherite", 7.0);
    public static final DragonArmorMaterial DRAGON_STEEL_FIRE = new DragonArmorMaterial("dragon_steel_fire", 10.0);
    public static final DragonArmorMaterial DRAGON_STEEL_ICE = new DragonArmorMaterial("dragon_steel_ice", 10.0);
    public static final DragonArmorMaterial DRAGON_STEEL_LIGHTNING = new DragonArmorMaterial("dragon_steel_lightning", 10.0);
    private final String name;
    private final double protection;

    public DragonArmorMaterial(String name, double protection) {
        this.name = name;
        this.protection = protection;
        MATERIALS.add(this);
    }

    public static ResourceLocation getArmorTexture(ItemStack stack, EquipmentSlot slot) {
        Item item;
        if (!stack.isEmpty() && (item = stack.getItem()) instanceof ItemDragonArmor) {
            ItemDragonArmor armorItem = (ItemDragonArmor)item;
            return armorItem.type.getTexture(slot);
        }
        return ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"missing");
    }

    public static List<DragonArmorMaterial> values() {
        return ImmutableList.copyOf(MATERIALS);
    }

    public String getId() {
        return this.name.toLowerCase(Locale.ROOT);
    }

    public double getProtection() {
        return this.protection;
    }

    public ResourceLocation getTexture(EquipmentSlot slot) {
        return switch (slot) {
            default -> throw new MatchException(null, null);
            case EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND -> null;
            case EquipmentSlot.FEET -> ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)("textures/entity/dragon_armor/armor_tail_" + this.name + ".png"));
            case EquipmentSlot.LEGS -> ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)("textures/entity/dragon_armor/armor_body_" + this.name + ".png"));
            case EquipmentSlot.CHEST -> ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)("textures/entity/dragon_armor/armor_neck_" + this.name + ".png"));
            case EquipmentSlot.HEAD -> ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)("textures/entity/dragon_armor/armor_head_" + this.name + ".png"));
            case EquipmentSlot.BODY -> ResourceLocation.parse((String)"");
        };
    }
}

